/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.grid.editor;

import com.vaadin.shared.communication.ServerRpc;

/**
 * An RPC interface for the grid editor client-to-server communications.
 *
 * @since 8.0
 * @author Vaadin Ltd
 */
public interface EditorServerRpc extends ServerRpc {

    /**
     * Asks the server to open the editor and bind data to it. When a bind
     * request is sent, it must be acknowledged with a
     * {@link EditorClientRpc#confirmBind(boolean) confirm call} before the
     * client can open the editor.
     *
     * @param key
     *            the identifier key for edited item
     */
    void bind(String key);

    /**
     * Asks the server to save unsaved changes in the editor to the bean. When a
     * save request is sent, it must be acknowledged with a
     * {@link EditorClientRpc#confirmSave(boolean) confirm call}.
     */
    void save();

    /**
     * Tells the server to cancel editing. When sending a cancel request, the
     * client does not need to wait for confirmation by the server before hiding
     * the editor.
     *
     * @param afterBeingSaved
     *            if {@code true} then this method is called to close editor
     *            after save action, otherwise it represents a cancel action
     */
    void cancel(boolean afterBeingSaved);

    /**
     * Asks the server to check the validity of the current values in the
     * editor. When a check-validity request is sent, the server must respond
     * with a {@link EditorClientRpc#confirmValidity(boolean) confirm call}.
     */
    void checkValidity();
}
