/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.combobox;

import com.vaadin.shared.communication.ClientRpc;

/**
 * Server to client RPC interface for ComboBox.
 *
 * @since 8.3.1
 */
public interface ComboBoxClientRpc extends ClientRpc {

    /**
     * Signal the client that attempt to add a new item failed.
     *
     * @param itemValue
     *            user entered string value for the new item
     */
    public void newItemNotAdded(String itemValue);
}
