/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.data.selection;

import com.vaadin.shared.communication.ServerRpc;

/**
 * Transmits SelectionModel selection events from the client to the server.
 *
 * @since 8.0
 */
public interface SelectionServerRpc extends ServerRpc {

    /**
     * Selects an item based on its key.
     *
     * @param key
     *            the key of the item to select
     */
    void select(String key);

    /**
     * Deselects an item based on its key.
     *
     * @param key
     *            the key of the item to deselect
     */
    void deselect(String key);
}
