/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.data.selection;

import java.util.Set;

import com.vaadin.shared.communication.ServerRpc;

/**
 * Transmits SelectionModel selection changes from the client to the server.
 *
 * @author Vaadin Ltd
 *
 * @since 8.0
 */
public interface MultiSelectServerRpc extends ServerRpc {

    /**
     * Updates the selected items based on their keys.
     *
     * @param addedItemKeys
     *            the item keys added to selection
     * @param removedItemKeys
     *            the item keys removed from selection
     */
    void updateSelection(Set<String> addedItemKeys,
            Set<String> removedItemKeys);
}
