/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.data;

import java.io.Serializable;

/**
 * Set of contants used by DataCommunicator. These are commonly used JsonObject
 * keys which are considered to be reserved for internal use.
 *
 * @since 8.0
 */
public final class DataCommunicatorConstants implements Serializable {
    public static final String KEY = "k";
    public static final String SELECTED = "s";
    public static final String NAME = "n";
    public static final String DATA = "d";
}
