/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.osgi.resources;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

/**
 * {@link BundleActivator} used to provide access to the
 * {@link VaadinResourceService} singleton for publishing themes, widgetsets and
 * other necessary resources.
 *
 * @author Vaadin Ltd.
 *
 * @since 8.1
 * @deprecated use OSGi DS services to bind a instance of
 *             {@link VaadinResourceService}
 */
public class OsgiVaadinResources implements BundleActivator {

    /**
     * Thrown if a method is called when the Resource bundle is not active.
     *
     * @author Vaadin Ltd.
     *
     * @since 8.1
     */
    @SuppressWarnings("serial")
    public static class ResourceBundleInactiveException extends Exception {
        public ResourceBundleInactiveException(String message) {
            super(message);
        }
    }

    private static OsgiVaadinResources instance;

    private ServiceTracker<VaadinResourceService, VaadinResourceService> vaadinResourceTracker;
    private VaadinResourceService service;

    /**
     * Returns the {@link VaadinResourceService} instance. Always returns
     * non-null.
     *
     * @return the {@link VaadinResourceService resource service} to use for
     *         publishing themes, widgetsets and other necessary resources
     * @throws ResourceBundleInactiveException
     *             if the bundle is not active
     */
    public static VaadinResourceService getService()
            throws ResourceBundleInactiveException {
        if (instance == null) {
            throw new ResourceBundleInactiveException(
                    "Vaadin Shared is not active!");
        }
        return instance.service;
    }

    @Override
    public void start(BundleContext context) throws Exception {
        vaadinResourceTracker = new ServiceTracker<VaadinResourceService, VaadinResourceService>(
                context, VaadinResourceService.class, null) {
            @Override
            public VaadinResourceService addingService(
                    ServiceReference<VaadinResourceService> reference) {
                VaadinResourceService vaadinService = super.addingService(
                        reference);
                service = vaadinService;
                return vaadinService;
            }

            @Override
            public void removedService(
                    ServiceReference<VaadinResourceService> reference,
                    VaadinResourceService service) {
                super.removedService(reference, service);
                if (OsgiVaadinResources.this.service == service) {
                    OsgiVaadinResources.this.service = null;
                }
            }
        };
        vaadinResourceTracker.open();
        instance = this;
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        if (vaadinResourceTracker != null) {
            vaadinResourceTracker.close();
        }
        vaadinResourceTracker = null;
        instance = null;
        service = null;
    }
}
