/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.treegrid;

import com.vaadin.shared.communication.ServerRpc;

/**
 * RPC to handle client originated collapse and expand actions on hierarchical
 * rows in TreeGrid.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
@FunctionalInterface
public interface NodeCollapseRpc extends ServerRpc {

    /**
     * Sets the collapse state of a hierarchical row in TreeGrid.
     *
     * @param rowKey
     *            the row's key
     * @param rowIndex
     *            index where the row is in grid (all rows)
     * @param collapse
     *            {@code true} to collapse, {@code false} to expand
     * @param userOriginated
     *            {@code true} if this RPC was triggered by a user interaction,
     *            {@code false} otherwise
     */
    void setNodeCollapsed(String rowKey, int rowIndex, boolean collapse,
            boolean userOriginated);
}
