/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.richtextarea;

import com.vaadin.shared.communication.ServerRpc;

/**
 * Client to server RPC interface for RichTextArea.
 *
 * @since 8.0
 */
public interface RichTextAreaServerRpc extends ServerRpc {

    /**
     * Sends the updated text to the server.
     *
     * @param text
     *            the text in the field
     */
    void setText(String text);
}
