/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.dnd;

/**
 * Used to specify the effect that is allowed for a drag operation.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
public enum EffectAllowed {
    /**
     * The item may not be dropped.
     */
    NONE("none"),

    /**
     * A copy of the source item may be made at the new location.
     */
    COPY("copy"),

    /**
     * An item may be moved to a new location.
     */
    MOVE("move"),

    /**
     * A link may be established to the source at the new location.
     */
    LINK("link"),

    /**
     * A copy or move operation is permitted.
     */
    COPY_MOVE("copyMove"),

    /**
     * A copy or link operation is permitted.
     */
    COPY_LINK("copyLink"),

    /**
     * A link or move operation is permitted.
     */
    LINK_MOVE("linkMove"),

    /**
     * All operations are permitted.
     */
    ALL("all"),

    /**
     * Default state, equivalent to ALL.
     */
    UNINITIALIZED("uninitialized");

    private final String value;

    EffectAllowed(String value) {
        this.value = value;
    }

    /**
     * Get the string value that is accepted by the client side drag event.
     *
     * @return String value accepted by the client side drag event.
     */
    public String getValue() {
        return value;
    }
}
