/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared;

import java.io.Serializable;

/**
 * A registration object for removing an event listener added to a source.
 *
 * @author Vaadin Ltd.
 * @since 8.0
 */
@FunctionalInterface
public interface Registration extends Serializable {

    /**
     * Removes the associated listener from the event source.
     */
    public void remove();
}
