/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.osgi.resources;

import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

/**
 * Service used to publish themes, widgetsets and static resources at the root
 * of a versioned namespaced /VAADIN/ folder.
 *
 * @author Vaadin Ltd.
 *
 * @since 8.1
 */
public interface VaadinResourceService {
    /**
     * Register the theme with the given name under the
     * {@link VaadinResourceService} versioned namespace. The theme folder is
     * expected to be compiled and under "/VAADIN/themes/" in the calling
     * bundle.
     *
     * The theme will become accessible under the url
     * "/vaadin-x.x.x/VAADIN/themes/themeName" where x.x.x is the version of the
     * Vaadin Shared bundle
     *
     * @deprecated use OSGi DS services and register a {@link OsgiVaadinTheme}
     * @param themeName
     *            the name of the theme
     * @param httpService
     *            the {@link HttpService} instance for the calling bundle
     * @throws NamespaceException
     *             if there is a clash during the theme registration
     */
    @Deprecated
    void publishTheme(String themeName, HttpService httpService)
            throws NamespaceException;

    /**
     * Register the resource with the given name under the
     * {@link VaadinResourceService} versioned namespace. The resource is
     * expected to be under "/VAADIN/" in the calling bundle.
     *
     * The resource will become accessible under the url "/vaadin-x.x.x/VAADIN/"
     * where x.x.x is the version of the Vaadin Shared bundle
     *
     * @deprecated use OSGi DS services and register a
     *             {@link OsgiVaadinResource}
     * @param resourceName
     *            the name of the resource
     * @param httpService
     *            the {@link HttpService} instance for the calling bundle
     * @throws NamespaceException
     *             if there is a clash during the theme registration
     */
    @Deprecated
    void publishResource(String resourceName, HttpService httpService)
            throws NamespaceException;

    /**
     * Register the widgetset with the given name under the
     * {@link VaadinResourceService} versioned namespace. The resource is
     * expected to be under "/VAADIN/widgetsets" in the calling bundle.
     *
     * The resource will become accessible under the url
     * "/vaadin-x.x.x/VAADIN/widgetsets" where x.x.x is the version of the
     * Vaadin Shared bundle
     *
     * @deprecated use OSGi DS services and register a
     *             {@link OsgiVaadinWidgetset}
     * @param widgetsetName
     *            the name of the resource
     * @param httpService
     *            the {@link HttpService} instance for the calling bundle
     * @throws NamespaceException
     *             if there is a clash during the theme registration
     */
    @Deprecated
    void publishWidgetset(String widgetsetName, HttpService httpService)
            throws NamespaceException;

    /**
     * Returns the prefix of the versioned namespace for the resources. The
     * result can't be null and is of the format "vaadin-x.x.x" where x.x.x the
     * version of the Vaadin Shared bundle.
     *
     * @return the prefix of the resources folder managed by this service
     */
    String getResourcePathPrefix();

    /**
     * Returns the http servlet context name of Vaadin
     *
     * @return the context name
     */
    String getContextName();
}
