/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui;

import java.io.Serializable;

/**
 * JSON key constants for common listing item attributes in server-client
 * communication.
 *
 * @author Vaadin Ltd
 * @since 8.0
 */
public class ListingJsonConstants implements Serializable {
    public static final String JSONKEY_ITEM_DISABLED = "d";

    public static final String JSONKEY_ITEM_ICON = "i";

    public static final String JSONKEY_ITEM_VALUE = "v";

    public static final String JSONKEY_ITEM_SELECTED = "s";

    /**
     * @since 8.2
     */
    public static final String JSONKEY_ITEM_DESCRIPTION = "dsc";
}
