/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.dnd;

/**
 * Used to specify the drop effect to use on dragenter or dragover events.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
public enum DropEffect {
    /**
     * A copy of the source item is made at the new location.
     */
    COPY,

    /**
     * An item is moved to a new location.
     */
    MOVE,

    /**
     * A link is established to the source at the new location.
     */
    LINK,

    /**
     * The item may not be dropped.
     */
    NONE
}
