/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui.components.grid;

import com.vaadin.data.ValueProvider;
import com.vaadin.ui.Grid;
import com.vaadin.ui.components.grid.FooterCell;
import com.vaadin.ui.components.grid.FooterRow;
import com.vaadin.ui.components.grid.HeaderCell;
import com.vaadin.ui.components.grid.HeaderRow;
import com.vaadin.ui.components.grid.StaticSection;
import java.util.Arrays;
import java.util.HashSet;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StaticSectionTest {
    private final Grid<String> grid = new Grid();
    private final Grid.Column<String, String> col1 = this.grid.addColumn(ValueProvider.identity()).setId("col1");
    private final Grid.Column<String, String> col2 = this.grid.addColumn(ValueProvider.identity()).setId("col2");
    private final Grid.Column<String, String> col3 = this.grid.addColumn(ValueProvider.identity()).setId("col3");
    private HeaderRow headerRow;
    private FooterRow footerRow;

    @Before
    public void setUp() {
        this.footerRow = this.grid.addFooterRowAt(0);
        this.headerRow = this.grid.addHeaderRowAt(0);
    }

    @Test
    public void joinFootersBySet() {
        this.footerRow.join(new HashSet<FooterCell>(Arrays.asList(this.footerRow.getCell(this.col1), this.footerRow.getCell(this.col2))));
        this.assertFootersJoined();
    }

    @Test
    public void joinFootersByCells() {
        this.footerRow.join(new FooterCell[]{this.footerRow.getCell(this.col1), this.footerRow.getCell(this.col2)});
        this.assertFootersJoined();
    }

    @Test
    public void joinFootersByColumns() {
        this.footerRow.join(new Grid.Column[]{this.col1, this.col2});
        this.assertFootersJoined();
    }

    @Test
    public void joinFootersByIds() {
        this.footerRow.join(new String[]{"col1", "col2"});
        this.assertFootersJoined();
    }

    @Test
    public void joinHeadersBySet() {
        this.headerRow.join(new HashSet<HeaderCell>(Arrays.asList(this.headerRow.getCell(this.col1), this.headerRow.getCell(this.col2))));
        this.assertHeadersJoined();
    }

    @Test
    public void joinHeadersByCells() {
        this.headerRow.join(new HeaderCell[]{this.headerRow.getCell(this.col1), this.headerRow.getCell(this.col2)});
        this.assertHeadersJoined();
    }

    @Test
    public void joinHeadersByColumns() {
        this.headerRow.join(new Grid.Column[]{this.col1, this.col2});
        this.assertHeadersJoined();
    }

    @Test
    public void joinHeadersByIds() {
        this.headerRow.join(new String[]{"col1", "col2"});
        this.assertHeadersJoined();
    }

    @Test(expected=IllegalStateException.class)
    public void joinHeadersByMissingIds() {
        this.headerRow.join(new String[]{"col1", "col4"});
    }

    @Test(expected=IllegalStateException.class)
    public void joinFootersByMissingIds() {
        this.headerRow.join(new String[]{"col1", "col4"});
    }

    private void assertFootersJoined() {
        StaticSectionTest.assertJoined((StaticSection.StaticRow)this.footerRow);
    }

    private void assertHeadersJoined() {
        StaticSectionTest.assertJoined((StaticSection.StaticRow)this.headerRow);
    }

    private static void assertJoined(StaticSection.StaticRow<?> staticRow) {
        Element container = new Element(Tag.valueOf((String)"container"), "");
        staticRow.writeDesign(container, null);
        Assert.assertEquals((long)2L, (long)container.children().size());
        Assert.assertEquals((Object)"col1,col2", (Object)container.child(0).attr("column-ids"));
        Assert.assertEquals((Object)"col3", (Object)container.child(1).attr("column-ids"));
    }
}

