/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.data.HasValue;
import com.vaadin.ui.TextArea;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TextAreaConstructorTest {
    @Test
    public void initiallyEmpty() {
        TextArea textArea = new TextArea();
        Assert.assertTrue((boolean)textArea.isEmpty());
    }

    @Test
    public void testValueConstructor_emptyAfterClear() {
        TextArea textArea = new TextArea(null, "foobar");
        Assert.assertFalse((boolean)textArea.isEmpty());
        textArea.clear();
        Assert.assertTrue((boolean)textArea.isEmpty());
    }

    @Test
    public void testValueChangeListener_eventOnValueChange() {
        HasValue.ValueChangeListener valueChangeListener = (HasValue.ValueChangeListener)Mockito.mock(HasValue.ValueChangeListener.class);
        TextArea textArea = new TextArea(valueChangeListener);
        textArea.setValue("value change");
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener)).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
    }

    @Test
    public void testCaptionValueListener() {
        HasValue.ValueChangeListener valueChangeListener = (HasValue.ValueChangeListener)Mockito.mock(HasValue.ValueChangeListener.class);
        TextArea textArea = new TextArea("Caption", "Initial value", valueChangeListener);
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener, (VerificationMode)Mockito.never())).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
        textArea.setValue("value change");
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener)).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
    }
}

