/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.ServerRpcManager;
import com.vaadin.shared.ui.richtextarea.RichTextAreaServerRpc;
import com.vaadin.tests.util.MockUI;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentTest;
import com.vaadin.ui.RichTextArea;
import org.junit.Assert;
import org.junit.Test;

public class RichTextAreaTest {
    @Test
    public void initiallyEmpty() {
        RichTextArea tf = new RichTextArea();
        Assert.assertTrue((boolean)tf.isEmpty());
    }

    @Test
    public void setValueServerWhenReadOnly() {
        RichTextArea tf = new RichTextArea();
        tf.setReadOnly(true);
        tf.setValue("foo");
        Assert.assertEquals((Object)"foo", (Object)tf.getValue());
    }

    @Test
    public void diffStateAfterClientSetValueWhenReadOnly() {
        MockUI ui = new MockUI();
        RichTextArea rta = new RichTextArea();
        ui.setContent((Component)rta);
        rta.setValue("bar");
        rta.setReadOnly(true);
        ComponentTest.syncToClient((AbstractComponent)rta);
        ((RichTextAreaServerRpc)ServerRpcManager.getRpcProxy((ClientConnector)rta, RichTextAreaServerRpc.class)).setText("foo");
        Assert.assertEquals((Object)"foo", (Object)this.getDiffStateString((ClientConnector)rta, "value"));
        Assert.assertTrue((String)"Component should be marked dirty", (boolean)ComponentTest.isDirty((ClientConnector)rta));
    }

    @Test
    public void setValueClientNotSentBack() throws ServerRpcManager.RpcInvocationException {
        MockUI ui = new MockUI();
        RichTextArea rta = new RichTextArea();
        ui.setContent((Component)rta);
        rta.setValue("bar");
        ComponentTest.updateDiffState((AbstractComponent)rta);
        ((RichTextAreaServerRpc)ServerRpcManager.getRpcProxy((ClientConnector)rta, RichTextAreaServerRpc.class)).setText("foo");
        Assert.assertEquals((Object)"foo", (Object)this.getDiffStateString((ClientConnector)rta, "value"));
    }

    private String getDiffStateString(ClientConnector connector, String key) {
        return connector.getUI().getConnectorTracker().getDiffState(connector).get(key).asString();
    }

    @Test
    public void setValueClientRefusedWhenReadOnly() {
        RichTextArea tf = new RichTextArea();
        tf.setValue("bar");
        tf.setReadOnly(true);
        tf.setValue((Object)"foo", true);
        Assert.assertEquals((Object)"bar", (Object)tf.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void setValue_nullValue_throwsNPE() {
        RichTextArea tf = new RichTextArea();
        tf.setValue(null);
    }

    @Test
    public void emptyAfterClear() {
        RichTextArea tf = new RichTextArea();
        tf.setValue("foobar");
        Assert.assertFalse((boolean)tf.isEmpty());
        tf.clear();
        Assert.assertTrue((boolean)tf.isEmpty());
    }
}

