/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.data.HasValue;
import com.vaadin.ui.RichTextArea;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RichTextAreaConstructorTest {
    @Test
    public void initiallyEmpty() {
        RichTextArea richTextArea = new RichTextArea();
        Assert.assertTrue((boolean)richTextArea.isEmpty());
    }

    @Test
    public void testValueConstructor_emptyAfterClear() {
        RichTextArea richTextArea = new RichTextArea(null, "foobar");
        Assert.assertFalse((boolean)richTextArea.isEmpty());
        richTextArea.clear();
        Assert.assertTrue((boolean)richTextArea.isEmpty());
    }

    @Test
    public void testValueChangeListener_eventOnValueChange() {
        HasValue.ValueChangeListener valueChangeListener = (HasValue.ValueChangeListener)Mockito.mock(HasValue.ValueChangeListener.class);
        RichTextArea richTextArea = new RichTextArea(valueChangeListener);
        richTextArea.setValue("value change");
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener)).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
    }

    @Test
    public void testCaptionValueListener() {
        HasValue.ValueChangeListener valueChangeListener = (HasValue.ValueChangeListener)Mockito.mock(HasValue.ValueChangeListener.class);
        RichTextArea richTextArea = new RichTextArea("Caption", "Initial value", valueChangeListener);
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener, (VerificationMode)Mockito.never())).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
        richTextArea.setValue("value change");
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener)).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
    }
}

