/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.data.HasValue;
import com.vaadin.ui.PasswordField;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PasswordFieldConstructorTest {
    @Test
    public void initiallyEmpty() {
        PasswordField passwordField = new PasswordField();
        Assert.assertTrue((boolean)passwordField.isEmpty());
    }

    @Test
    public void testValueConstructor_emptyAfterClear() {
        PasswordField passwordField = new PasswordField(null, "foobar");
        Assert.assertFalse((boolean)passwordField.isEmpty());
        passwordField.clear();
        Assert.assertTrue((boolean)passwordField.isEmpty());
    }

    @Test
    public void testValueChangeListener_eventOnValueChange() {
        HasValue.ValueChangeListener valueChangeListener = (HasValue.ValueChangeListener)Mockito.mock(HasValue.ValueChangeListener.class);
        PasswordField passwordField = new PasswordField(valueChangeListener);
        passwordField.setValue("value change");
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener)).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
    }

    @Test
    public void testCaptionValueListener() {
        HasValue.ValueChangeListener valueChangeListener = (HasValue.ValueChangeListener)Mockito.mock(HasValue.ValueChangeListener.class);
        PasswordField passwordField = new PasswordField("Caption", "Initial value", valueChangeListener);
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener, (VerificationMode)Mockito.never())).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
        passwordField.setValue("value change");
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener)).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
    }
}

