/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.data.HasValue;
import com.vaadin.shared.ui.datefield.DateTimeResolution;
import com.vaadin.ui.DateTimeField;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DateTimeFieldConstructorTest {
    @Test
    public void initiallyEmpty() {
        DateTimeField dateTimeField = new DateTimeField();
        Assert.assertTrue((boolean)dateTimeField.isEmpty());
        Assert.assertEquals((Object)DateTimeResolution.MINUTE, (Object)dateTimeField.getResolution());
    }

    @Test
    public void testValueConstructor_emptyAfterClear() {
        DateTimeField dateTimeField = new DateTimeField(null, LocalDateTime.now());
        Assert.assertFalse((boolean)dateTimeField.isEmpty());
        Assert.assertEquals((Object)DateTimeResolution.MINUTE, (Object)dateTimeField.getResolution());
        dateTimeField.clear();
        Assert.assertTrue((boolean)dateTimeField.isEmpty());
    }

    @Test
    public void testValueChangeListener_eventOnValueChange() {
        HasValue.ValueChangeListener valueChangeListener = (HasValue.ValueChangeListener)Mockito.mock(HasValue.ValueChangeListener.class);
        DateTimeField dateTimeField = new DateTimeField(valueChangeListener);
        Assert.assertEquals((Object)DateTimeResolution.MINUTE, (Object)dateTimeField.getResolution());
        dateTimeField.setValue((Temporal)LocalDateTime.now());
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener)).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
    }

    @Test
    public void testCaptionValueListener() {
        HasValue.ValueChangeListener valueChangeListener = (HasValue.ValueChangeListener)Mockito.mock(HasValue.ValueChangeListener.class);
        DateTimeField dateTimeField = new DateTimeField("Caption", LocalDateTime.now(), valueChangeListener);
        Assert.assertEquals((Object)DateTimeResolution.MINUTE, (Object)dateTimeField.getResolution());
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener, (VerificationMode)Mockito.never())).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
        dateTimeField.setValue((Temporal)LocalDateTime.now().plusDays(1L));
        ((HasValue.ValueChangeListener)Mockito.verify((Object)valueChangeListener)).valueChange((HasValue.ValueChangeEvent)Mockito.any(HasValue.ValueChangeEvent.class));
    }
}

