/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.ui.AbstractLocalDateField;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DateFieldTestCase {
    private AbstractLocalDateField dateField;
    private LocalDate date;
    @Rule
    public transient ExpectedException exceptionRule = ExpectedException.none();

    @Before
    public void setup() {
        this.dateField = new AbstractLocalDateField(){};
        this.date = LocalDate.now();
    }

    @Test
    public void rangeStartIsSetToNull() {
        this.dateField.setRangeStart(null);
        MatcherAssert.assertThat((Object)((LocalDate)this.dateField.getRangeStart()), (Matcher)CoreMatchers.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void rangeStartIsAcceptedAsValue() {
        this.dateField.setRangeStart((Temporal)this.date);
        this.dateField.setValue((Temporal)this.date);
        Assert.assertNull((Object)this.dateField.getComponentError());
    }

    @Test
    public void belowRangeStartIsNotAcceptedAsValue() {
        LocalDate currentDate = (LocalDate)this.dateField.getValue();
        this.dateField.setRangeStart((Temporal)this.date);
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.dateField.setValue((Temporal)this.date.minusDays(1L));
        MatcherAssert.assertThat((Object)((LocalDate)this.dateField.getValue()), (Matcher)CoreMatchers.is((Object)currentDate));
    }

    @Test
    public void rangeEndIsSetToNull() {
        this.dateField.setRangeEnd(null);
        MatcherAssert.assertThat((Object)((LocalDate)this.dateField.getRangeEnd()), (Matcher)CoreMatchers.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void rangeEndIsAcceptedAsValue() {
        this.dateField.setRangeEnd((Temporal)this.date);
        this.dateField.setValue((Temporal)this.date);
        Assert.assertNull((Object)this.dateField.getComponentError());
    }

    @Test
    public void aboveRangeEndIsNotAcceptedAsValue() {
        LocalDate currentDate = (LocalDate)this.dateField.getValue();
        this.dateField.setRangeEnd((Temporal)this.date);
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.dateField.setValue((Temporal)this.date.plusDays(1L));
        MatcherAssert.assertThat((Object)((LocalDate)this.dateField.getValue()), (Matcher)CoreMatchers.is((Object)currentDate));
    }
}

