/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.LegacyCommunicationManager;
import com.vaadin.server.ServerRpcManager;
import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.shared.communication.SharedState;
import com.vaadin.ui.AbstractComponent;
import elemental.json.JsonObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;

public class ComponentTest {
    public static void syncToClient(AbstractComponent component) {
        ComponentTest.updateDiffState(component);
        component.getUI().getConnectorTracker().markClean((ClientConnector)component);
    }

    public static boolean isDirty(ClientConnector connector) {
        return connector.getUI().getConnectorTracker().isDirty(connector);
    }

    public static void updateDiffState(AbstractComponent component) {
        LegacyCommunicationManager.encodeState((ClientConnector)component, (SharedState)component.getState());
    }

    public static <T extends ServerRpc> T getRpcProxy(ClientConnector connector, Class<T> serverRpcClass) {
        try {
            ServerRpcManager rpcManager = connector.getRpcManager(serverRpcClass.getName());
            Method method = ServerRpcManager.class.getDeclaredMethod("getImplementation", new Class[0]);
            method.setAccessible(true);
            return (T)((ServerRpc)serverRpcClass.cast(method.invoke((Object)rpcManager, new Object[0])));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertEncodedStateProperties(ClientConnector connector, String message, String ... expectedProperties) {
        assert (connector.isAttached());
        JsonObject encodeState = connector.encodeState();
        Assert.assertEquals((String)message, new HashSet<String>(Arrays.asList(expectedProperties)), new HashSet<String>(Arrays.asList(encodeState.keys())));
    }

    private ComponentTest() {
    }
}

