/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.util;

import com.vaadin.tests.VaadinClasses;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GraphVizClassHierarchyCreator {
    public static void main(String[] args) {
        String gv = GraphVizClassHierarchyCreator.getGraphVizHierarchy(VaadinClasses.getComponents(), "com.vaadin");
        System.out.println(gv);
    }

    private static String getGraphVizHierarchy(List<Class> classes, String packageToInclude) {
        boolean includeInterfaces = false;
        StringBuilder header = new StringBuilder();
        header.append("digraph finite_state_machine {\n        rankdir=BT;\n        dpi=\"150\";\n                ratio=\"0.25\";\n");
        StringBuilder sb = new StringBuilder();
        HashSet<Class> classesAndParents = new HashSet<Class>();
        for (Class cls : classes) {
            GraphVizClassHierarchyCreator.addClassAndParents(classesAndParents, cls, packageToInclude);
        }
        HashSet interfaces = new HashSet();
        for (Object e : classesAndParents) {
            for (Class<?> c : ((Class)e).getInterfaces()) {
                GraphVizClassHierarchyCreator.addClassAndParentInterfaces(classesAndParents, c, packageToInclude);
            }
        }
        for (Class clazz : classesAndParents) {
            GraphVizClassHierarchyCreator.appendClass(sb, clazz, clazz.getSuperclass(), packageToInclude, includeInterfaces);
            for (Class<?> ci : clazz.getInterfaces()) {
                GraphVizClassHierarchyCreator.appendClass(sb, clazz, ci, packageToInclude, includeInterfaces);
            }
        }
        header.append("    node [shape = ellipse, style=\"dotted\"] ");
        for (Class clazz : classesAndParents) {
            if (clazz.isInterface() || !Modifier.isAbstract(clazz.getModifiers())) continue;
            header.append(clazz.getSimpleName()).append(' ');
        }
        if (includeInterfaces) {
            System.out.print("    node [shape = ellipse, style=\"solid\"] ");
            for (Class clazz : classesAndParents) {
                if (!clazz.isInterface()) continue;
                header.append(clazz.getSimpleName()).append(' ');
            }
            header.append(";\n");
        }
        header.append(";\n");
        header.append("    node [shape = rectangle, style=\"solid\"];\n");
        return header.toString() + sb.toString() + "}";
    }

    private static void addClassAndParents(Set<Class> classesAndParents, Class<?> cls, String packageToInclude) {
        if (cls == null) {
            return;
        }
        if (classesAndParents.contains(cls)) {
            return;
        }
        if (!cls.getPackage().getName().startsWith(packageToInclude)) {
            return;
        }
        classesAndParents.add(cls);
        GraphVizClassHierarchyCreator.addClassAndParents(classesAndParents, cls.getSuperclass(), packageToInclude);
    }

    private static void addClassAndParentInterfaces(Set<Class> classesAndParents, Class<?> cls, String packageToInclude) {
        if (cls == null) {
            return;
        }
        if (classesAndParents.contains(cls)) {
            return;
        }
        if (!cls.getPackage().getName().startsWith(packageToInclude)) {
            return;
        }
        classesAndParents.add(cls);
        for (Class<?> iClass : cls.getInterfaces()) {
            GraphVizClassHierarchyCreator.addClassAndParentInterfaces(classesAndParents, iClass, packageToInclude);
        }
    }

    private static void appendClass(StringBuilder sb, Class<?> c, Class<?> superClass, String packageToInclude, boolean includeInterfaces) {
        if (superClass == null) {
            return;
        }
        if (!c.getPackage().getName().startsWith(packageToInclude)) {
            return;
        }
        if (!superClass.getPackage().getName().startsWith(packageToInclude)) {
            return;
        }
        if (!includeInterfaces && (c.isInterface() || superClass.isInterface())) {
            return;
        }
        sb.append(c.getSimpleName()).append(" -> ").append(superClass.getSimpleName()).append("\n");
    }
}

