/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.navigator;

import com.vaadin.navigator.NavigationStateManager;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.PushStateNavigation;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewBeforeLeaveEvent;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.navigator.ViewDisplay;
import com.vaadin.navigator.ViewLeaveAction;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.server.Page;
import com.vaadin.server.VaadinRequest;
import com.vaadin.shared.Registration;
import com.vaadin.shared.ui.ui.PageState;
import com.vaadin.tests.server.navigator.ClassBasedViewProviderTest;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.SingleComponentContainer;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.easymock.IMocksControl;
import org.junit.Assert;
import org.junit.Test;

public class NavigatorTest {
    public static ViewChangeListener.ViewChangeEvent eventParametersEqual(final String expected) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("paramsIs(\"").append(expected).append("\")");
            }

            public boolean matches(Object actual) {
                return actual instanceof ViewChangeListener.ViewChangeEvent && expected.equals(((ViewChangeListener.ViewChangeEvent)actual).getParameters());
            }
        });
        return null;
    }

    private static UI createMockUI() {
        UI ui = (UI)EasyMock.createMock(UI.class);
        ui.setNavigator((Navigator)EasyMock.anyObject(Navigator.class));
        EasyMock.replay((Object[])new Object[]{ui});
        return ui;
    }

    private static Navigator createNavigator(NavigationStateManager manager, ViewDisplay display) {
        return new Navigator(NavigatorTest.createMockUI(), manager, display);
    }

    @Test
    public void testDestroy_unsetNavigatorInUIAndUriFragmentManager() {
        TestPageWithUriFragments page = new TestPageWithUriFragments();
        TestUI ui = new TestUI(page);
        TestNavigatorWithFragments navigator = new TestNavigatorWithFragments(ui);
        Assert.assertTrue((String)"Add URI fragment Page method has not been called", (boolean)page.addUriFragmentCalled());
        Assert.assertFalse((String)"Unexpected remove URI fragment Page method call", (boolean)page.removeUriFragmentCalled());
        Assert.assertNotNull((String)"Navigator is null in UI", (Object)ui.getNavigator());
        navigator.destroy();
        Assert.assertTrue((String)"Remove URI fragment Page method has not been called after destroy", (boolean)page.removeUriFragmentCalled());
        Assert.assertNull((String)"Navigator is not null in UI after destroy", (Object)ui.getNavigator());
        try {
            page.setUriFragment("foobar", true);
            Assert.fail((String)"Expected null pointer exception after call uriFragmentChanged for destroyed navigator");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testDestroy_unsetNavigatorInUIAndPopstateManager() {
        TestPage page = new TestPage();
        TestPushStateUI ui = new TestPushStateUI(page);
        TestNavigator navigator = new TestNavigator(ui);
        Assert.assertTrue((String)"Add URI fragment Page method has not been called", (boolean)page.addPopstateCalled());
        Assert.assertFalse((String)"Unexpected remove URI fragment Page method call", (boolean)page.removePopstateCalled());
        Assert.assertNotNull((String)"Navigator is null in UI", (Object)ui.getNavigator());
        navigator.destroy();
        Assert.assertTrue((String)"Remove URI fragment Page method has not been called after destroy", (boolean)page.removePopstateCalled());
        Assert.assertNull((String)"Navigator is not null in UI after destroy", (Object)ui.getNavigator());
        try {
            page.updateLocation("http://server/path/info", true, true);
            Assert.fail((String)"Expected null pointer exception after call uriFragmentChanged for destroyed navigator");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicNavigation() {
        IMocksControl control = EasyMock.createControl();
        NavigationStateManager manager = (NavigationStateManager)control.createMock(NavigationStateManager.class);
        ViewDisplay display = (ViewDisplay)control.createMock(ViewDisplay.class);
        ViewProvider provider = (ViewProvider)control.createMock(ViewProvider.class);
        TestView view1 = new TestView();
        TestView view2 = new TestView();
        manager.setNavigator((Navigator)EasyMock.anyObject(Navigator.class));
        EasyMock.expect((Object)provider.getViewName("test1")).andReturn((Object)"test1").times(2);
        EasyMock.expect((Object)provider.getView("test1")).andReturn((Object)view1);
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"");
        display.showView((View)view1);
        manager.setState("test1");
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"test1");
        EasyMock.expect((Object)provider.getViewName("test2/")).andReturn((Object)"test2").times(2);
        EasyMock.expect((Object)provider.getView("test2")).andReturn((Object)view2);
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"test1");
        display.showView((View)view2);
        manager.setState("test2");
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"test2");
        EasyMock.expect((Object)provider.getViewName("test1/params")).andReturn((Object)"test1").times(2);
        EasyMock.expect((Object)provider.getView("test1")).andReturn((Object)view1);
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"test2");
        display.showView((View)view1);
        manager.setState("test1/params");
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"test1/params");
        control.replay();
        Navigator navigator = NavigatorTest.createNavigator(manager, display);
        navigator.addProvider(provider);
        navigator.navigateTo("test1");
        Assert.assertEquals((Object)"test1", (Object)navigator.getState());
        Assert.assertEquals((Object)"", (Object)view1.getParams());
        navigator.navigateTo("test2/");
        Assert.assertEquals((Object)"test2", (Object)navigator.getState());
        Assert.assertEquals((Object)"", (Object)view2.getParams());
        navigator.navigateTo("test1/params");
        Assert.assertEquals((Object)"test1/params", (Object)navigator.getState());
        Assert.assertEquals((Object)"params", (Object)view1.getParams());
    }

    @Test
    public void testMainView() {
        IMocksControl control = EasyMock.createControl();
        NavigationStateManager manager = (NavigationStateManager)control.createMock(NavigationStateManager.class);
        ViewDisplay display = (ViewDisplay)control.createMock(ViewDisplay.class);
        ViewProvider provider = (ViewProvider)control.createMock(ViewProvider.class);
        TestView view1 = new TestView();
        TestView view2 = new TestView();
        manager.setNavigator((Navigator)EasyMock.anyObject(Navigator.class));
        EasyMock.expect((Object)provider.getViewName("test2")).andReturn((Object)"test2").times(2);
        EasyMock.expect((Object)provider.getView("test2")).andReturn((Object)view2);
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"view1");
        display.showView((View)view2);
        manager.setState("test2");
        EasyMock.expect((Object)provider.getViewName("")).andReturn((Object)"test1").times(2);
        EasyMock.expect((Object)provider.getView("test1")).andReturn((Object)view1);
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"");
        display.showView((View)view1);
        manager.setState("test1");
        EasyMock.expect((Object)provider.getViewName("test1/params")).andReturn((Object)"test1").times(2);
        EasyMock.expect((Object)provider.getView("test1")).andReturn((Object)view1);
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"test2");
        display.showView((View)view1);
        manager.setState("test1/params");
        control.replay();
        Navigator navigator = NavigatorTest.createNavigator(manager, display);
        navigator.addProvider(provider);
        navigator.navigateTo("test2");
        Assert.assertEquals((Object)"", (Object)view2.getParams());
        Assert.assertEquals(null, (Object)view1.getParams());
        navigator.navigateTo("");
        Assert.assertEquals((Object)"", (Object)view1.getParams());
        navigator.navigateTo("test1/params");
        Assert.assertEquals((Object)"params", (Object)view1.getParams());
    }

    @Test
    public void testListeners() {
        IMocksControl control = EasyMock.createControl();
        NavigationStateManager manager = (NavigationStateManager)control.createMock(NavigationStateManager.class);
        ViewDisplay display = (ViewDisplay)control.createMock(ViewDisplay.class);
        ViewProvider provider = (ViewProvider)control.createMock(ViewProvider.class);
        TestView view1 = new TestView();
        TestView view2 = new TestView();
        ViewChangeTestListener listener = new ViewChangeTestListener();
        Navigator navigator = NavigatorTest.createNavigator(manager, display);
        EasyMock.expect((Object)provider.getViewName("test1")).andReturn((Object)"test1").times(2);
        EasyMock.expect((Object)provider.getView("test1")).andReturn((Object)view1);
        ViewChangeListener.ViewChangeEvent event1 = new ViewChangeListener.ViewChangeEvent(navigator, null, (View)view1, "test1", "");
        listener.addExpectedIsViewChangeAllowed(event1, true);
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"");
        display.showView((View)view1);
        manager.setState("test1");
        listener.addExpectedNavigatorViewChange(event1);
        EasyMock.expect((Object)provider.getViewName("test2")).andReturn((Object)"test2").times(2);
        EasyMock.expect((Object)provider.getView("test2")).andReturn((Object)view2);
        ViewChangeListener.ViewChangeEvent event2 = new ViewChangeListener.ViewChangeEvent(navigator, (View)view1, (View)view2, "test2", "");
        listener.addExpectedIsViewChangeAllowed(event2, true);
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"test1");
        display.showView((View)view2);
        manager.setState("test2");
        listener.addExpectedNavigatorViewChange(event2);
        control.replay();
        navigator.addProvider(provider);
        navigator.addViewChangeListener((ViewChangeListener)listener);
        navigator.navigateTo("test1");
        navigator.navigateTo("test2");
        if (!listener.isReady()) {
            Assert.fail((String)"Missing listener calls");
        }
    }

    @Test
    public void testComponentContainerViewDisplay() {
        class TestView
        extends VerticalLayout
        implements View {
            TestView() {
            }

            public void enter(ViewChangeListener.ViewChangeEvent event) {
            }
        }
        TestView tv1 = new TestView();
        TestView tv2 = new TestView();
        VerticalLayout container = new VerticalLayout();
        Navigator.ComponentContainerViewDisplay display = new Navigator.ComponentContainerViewDisplay((ComponentContainer)container);
        Navigator navigator = NavigatorTest.createNavigator(new NullFragmentManager(), (ViewDisplay)display);
        navigator.addView("tv1", (View)tv1);
        navigator.addView("tv2", (View)tv2);
        navigator.navigateTo("tv1");
        Assert.assertSame((Object)((Object)tv1), (Object)container.getComponent(0));
        Assert.assertEquals((long)1L, (long)container.getComponentCount());
        navigator.navigateTo("tv2");
        Assert.assertSame((Object)((Object)tv2), (Object)container.getComponent(0));
        Assert.assertEquals((long)1L, (long)container.getComponentCount());
    }

    @Test
    public void testBlockNavigation() {
        IMocksControl control = EasyMock.createControl();
        NavigationStateManager manager = (NavigationStateManager)control.createMock(NavigationStateManager.class);
        ViewDisplay display = (ViewDisplay)control.createMock(ViewDisplay.class);
        ViewProvider provider = (ViewProvider)control.createMock(ViewProvider.class);
        TestView view1 = new TestView();
        TestView view2 = new TestView();
        ViewChangeTestListener listener1 = new ViewChangeTestListener();
        ViewChangeTestListener listener2 = new ViewChangeTestListener();
        Navigator navigator = NavigatorTest.createNavigator(manager, display);
        EasyMock.expect((Object)provider.getViewName("test1")).andReturn((Object)"test1").times(2);
        EasyMock.expect((Object)provider.getView("test1")).andReturn((Object)view1);
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"");
        ViewChangeListener.ViewChangeEvent event1 = new ViewChangeListener.ViewChangeEvent(navigator, null, (View)view1, "test1", "");
        listener1.addExpectedIsViewChangeAllowed(event1, false);
        EasyMock.expect((Object)provider.getViewName("test1/test")).andReturn((Object)"test1").times(2);
        EasyMock.expect((Object)provider.getView("test1")).andReturn((Object)view1);
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"");
        ViewChangeListener.ViewChangeEvent event2 = new ViewChangeListener.ViewChangeEvent(navigator, null, (View)view1, "test1", "test");
        listener1.addExpectedIsViewChangeAllowed(event2, true);
        listener2.addExpectedIsViewChangeAllowed(event2, false);
        EasyMock.expect((Object)provider.getViewName("test1/bar")).andReturn((Object)"test1").times(2);
        EasyMock.expect((Object)provider.getView("test1")).andReturn((Object)view1);
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"");
        ViewChangeListener.ViewChangeEvent event3 = new ViewChangeListener.ViewChangeEvent(navigator, null, (View)view1, "test1", "bar");
        listener1.addExpectedIsViewChangeAllowed(event3, true);
        listener2.addExpectedIsViewChangeAllowed(event3, true);
        display.showView((View)view1);
        manager.setState("test1/bar");
        listener1.addExpectedNavigatorViewChange(event3);
        listener2.addExpectedNavigatorViewChange(event3);
        EasyMock.expect((Object)provider.getViewName("test2")).andReturn((Object)"test2").times(2);
        EasyMock.expect((Object)provider.getView("test2")).andReturn((Object)view2);
        EasyMock.expect((Object)manager.getState()).andReturn((Object)"view1");
        ViewChangeListener.ViewChangeEvent event4 = new ViewChangeListener.ViewChangeEvent(navigator, (View)view1, (View)view2, "test2", "");
        listener1.addExpectedIsViewChangeAllowed(event4, true);
        listener2.addExpectedIsViewChangeAllowed(event4, true);
        display.showView((View)view2);
        manager.setState("test2");
        listener1.addExpectedNavigatorViewChange(event4);
        listener2.addExpectedNavigatorViewChange(event4);
        control.replay();
        navigator.addProvider(provider);
        navigator.addViewChangeListener((ViewChangeListener)listener1);
        navigator.addViewChangeListener((ViewChangeListener)listener2);
        navigator.navigateTo("test1");
        navigator.navigateTo("test1/test");
        navigator.navigateTo("test1/bar");
        navigator.navigateTo("test2");
        if (!listener1.isReady()) {
            Assert.fail((String)"Missing listener calls for listener1");
        }
        if (!listener2.isReady()) {
            Assert.fail((String)"Missing listener calls for listener2");
        }
    }

    @Test
    public void testAddViewInstance() throws Exception {
        TestView view = new TestView();
        TestNavigator navigator = new TestNavigator();
        navigator.addView("test", view);
        Assert.assertEquals((String)"Registered view instance not returned by navigator", (Object)view, (Object)navigator.getView("test"));
    }

    @Test
    public void testAddViewInstanceSameName() throws Exception {
        TestView view1 = new TestView();
        ClassBasedViewProviderTest.TestView2 view2 = new ClassBasedViewProviderTest.TestView2();
        TestNavigator navigator = new TestNavigator();
        navigator.addView("test", view1);
        navigator.addView("test", view2);
        Assert.assertEquals((String)"Adding second view with same name should override previous view", (Object)((Object)view2), (Object)navigator.getView("test"));
    }

    @Test
    public void testAddViewClass() throws Exception {
        TestNavigator navigator = new TestNavigator();
        navigator.addView("test", TestView.class);
        View view = navigator.getView("test");
        Assert.assertNotNull((String)"Received null view", (Object)view);
        Assert.assertEquals((String)"Received incorrect type of view", TestView.class, view.getClass());
    }

    @Test
    public void testAddViewClassSameName() throws Exception {
        TestNavigator navigator = new TestNavigator();
        navigator.addView("test", TestView.class);
        navigator.addView("test", ClassBasedViewProviderTest.TestView2.class);
        Assert.assertEquals((String)"Adding second view class with same name should override previous view", ClassBasedViewProviderTest.TestView2.class, navigator.getView("test").getClass());
    }

    @Test
    public void testAddViewInstanceAndClassSameName() throws Exception {
        TestNavigator navigator = new TestNavigator();
        navigator.addView("test", TestView.class);
        ClassBasedViewProviderTest.TestView2 view2 = new ClassBasedViewProviderTest.TestView2();
        navigator.addView("test", view2);
        Assert.assertEquals((String)"Adding second view class with same name should override previous view", (Object)((Object)view2), (Object)navigator.getView("test"));
        navigator.addView("test", TestView.class);
        Assert.assertEquals((String)"Adding second view class with same name should override previous view", TestView.class, navigator.getView("test").getClass());
    }

    @Test
    public void testAddViewWithNullName() throws Exception {
        TestNavigator navigator = new TestNavigator();
        try {
            navigator.addView(null, new TestView());
            Assert.fail((String)"addView() accepted null view name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            navigator.addView(null, TestView.class);
            Assert.fail((String)"addView() accepted null view name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddViewWithNullInstance() throws Exception {
        TestNavigator navigator = new TestNavigator();
        navigator.addView("test", null);
        Assert.fail((String)"addView() accepted null view instance");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddViewWithNullClass() throws Exception {
        TestNavigator navigator = new TestNavigator();
        navigator.addView("test", null);
        Assert.fail((String)"addView() accepted null view class");
    }

    @Test
    public void testRemoveViewInstance() throws Exception {
        TestView view = new TestView();
        TestNavigator navigator = new TestNavigator();
        navigator.addView("test", view);
        navigator.removeView("test");
        Assert.assertNull((String)"View not removed", (Object)navigator.getView("test"));
    }

    @Test
    public void testRemoveViewInstanceNothingElse() throws Exception {
        TestView view = new TestView();
        ClassBasedViewProviderTest.TestView2 view2 = new ClassBasedViewProviderTest.TestView2();
        TestNavigator navigator = new TestNavigator();
        navigator.addView("test", view);
        navigator.addView("test2", view2);
        navigator.removeView("test");
        Assert.assertEquals((String)"Removed extra views", (Object)((Object)view2), (Object)navigator.getView("test2"));
    }

    @Test
    public void testRemoveViewClass() throws Exception {
        TestNavigator navigator = new TestNavigator();
        navigator.addView("test", TestView.class);
        navigator.removeView("test");
        Assert.assertNull((String)"View not removed", (Object)navigator.getView("test"));
    }

    @Test
    public void testRemoveViewClassNothingElse() throws Exception {
        TestNavigator navigator = new TestNavigator();
        navigator.addView("test", TestView.class);
        navigator.addView("test2", ClassBasedViewProviderTest.TestView2.class);
        navigator.removeView("test");
        Assert.assertEquals((String)"Removed extra views", ClassBasedViewProviderTest.TestView2.class, navigator.getView("test2").getClass());
    }

    @Test
    public void testGetViewNestedNames() throws Exception {
        TestNavigator navigator = new TestNavigator();
        navigator.addView("test/subview", ClassBasedViewProviderTest.TestView2.class);
        navigator.addView("test", TestView.class);
        Assert.assertEquals((String)"Incorrect view name found for subview string", ClassBasedViewProviderTest.TestView2.class, navigator.getView("test/subview").getClass());
        Assert.assertEquals((String)"Incorrect view name found for subview string with empty parameters", ClassBasedViewProviderTest.TestView2.class, navigator.getView("test/subview/").getClass());
        Assert.assertEquals((String)"Incorrect view name found for subview string with parameters", ClassBasedViewProviderTest.TestView2.class, navigator.getView("test/subview/parameters").getClass());
        Assert.assertEquals((String)"Incorrect view name found for top level view string", TestView.class, navigator.getView("test").getClass());
        Assert.assertEquals((String)"Incorrect view name found for top level view string with empty parameters", TestView.class, navigator.getView("test/").getClass());
        Assert.assertEquals((String)"Incorrect view name found for top level view string with parameters starting like subview name", TestView.class, navigator.getView("test/subviewnothere").getClass());
    }

    @Test
    public void testGetViewLongestPrefixOrder() throws Exception {
        TestNavigator navigator = new TestNavigator();
        navigator.addView("test/subview", ClassBasedViewProviderTest.TestView2.class);
        navigator.addView("test", TestView.class);
        Assert.assertEquals((String)"Incorrect view name found", TestView.class, navigator.getView("test").getClass());
        TestNavigator navigator2 = new TestNavigator();
        navigator2.addView("test", TestView.class);
        navigator2.addView("test/subview", ClassBasedViewProviderTest.TestView2.class);
        Assert.assertEquals((String)"Incorrect view name found", TestView.class, navigator2.getView("test").getClass());
    }

    @Test
    public void testNavigateToUnknownView() {
        TestNavigator navigator = new TestNavigator();
        TestView errorView = new TestView();
        try {
            navigator.navigateTo("doesnotexist");
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        navigator.setErrorView(errorView);
        navigator.navigateTo("doesnotexist");
        TestView testView = new TestView();
        navigator.addView("doesnotexist", testView);
        navigator.navigateTo("doesnotexist");
        TestView errorView2 = new TestView();
        ViewProvider errorProvider = (ViewProvider)EasyMock.createMock(ViewProvider.class);
        EasyMock.expect((Object)errorProvider.getView("doesnotexist2")).andReturn((Object)errorView2);
        EasyMock.expect((Object)errorProvider.getViewName("doesnotexist2")).andReturn((Object)"doesnotexist2");
        EasyMock.replay((Object[])new Object[]{errorProvider});
        navigator.setErrorProvider(errorProvider);
        navigator.navigateTo("doesnotexist2");
    }

    @Test
    public void testShowViewEnterOrder() {
        IMocksControl control = EasyMock.createStrictControl();
        View view = (View)control.createMock(View.class);
        ViewDisplay display = (ViewDisplay)control.createMock(ViewDisplay.class);
        display.showView(view);
        view.enter((ViewChangeListener.ViewChangeEvent)EasyMock.anyObject(ViewChangeListener.ViewChangeEvent.class));
        control.replay();
        NavigationStateManager manager = (NavigationStateManager)EasyMock.createNiceMock(NavigationStateManager.class);
        EasyMock.replay((Object[])new Object[]{manager});
        Navigator navigator = new Navigator(NavigatorTest.createMockUI(), manager, display);
        navigator.addView("view", view);
        navigator.navigateTo("view");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullViewProvider() {
        IMocksControl control = EasyMock.createControl();
        NavigationStateManager manager = (NavigationStateManager)control.createMock(NavigationStateManager.class);
        ViewDisplay display = (ViewDisplay)control.createMock(ViewDisplay.class);
        Navigator navigator = NavigatorTest.createNavigator(manager, display);
        navigator.addProvider(null);
        Assert.fail((String)"Should not be allowed to add a null view provider");
    }

    @Test
    public void testNavigateTo_navigateSameUriTwice_secondNavigationDoesNothing() {
        TestNavigationStateManager manager = new TestNavigationStateManager();
        String viewName = "view";
        final View view = (View)EasyMock.createMock(View.class);
        ViewProvider provider = new ViewProvider(){

            public String getViewName(String viewAndParameters) {
                return "view";
            }

            public View getView(String viewName) {
                return view;
            }
        };
        final int[] count = new int[]{0};
        Navigator navigator = new Navigator(NavigatorTest.createMockUI(), manager, (ViewDisplay)EasyMock.createMock(ViewDisplay.class)){

            protected void navigateTo(View view, String viewName, String parameters) {
                count[0] = count[0] + 1;
                super.navigateTo(view, viewName, parameters);
            }
        };
        navigator.addProvider(provider);
        navigator.navigateTo("view");
        Assert.assertEquals((long)1L, (long)count[0]);
        navigator.navigateTo("view");
        Assert.assertEquals((long)1L, (long)count[0]);
    }

    @Test
    public void viewWhichIsNotAComponent() {
        UI ui = new UI(){
            private Page page = new Page(this, new PageState()){
                private String fragment;
                {
                    this.fragment = "";
                }

                public String getUriFragment() {
                    return this.fragment;
                }

                public void setUriFragment(String newUriFragment, boolean fireEvents) {
                    this.fragment = newUriFragment;
                }
            };

            protected void init(VaadinRequest request) {
            }

            public Page getPage() {
                return this.page;
            }
        };
        Navigator navigator = new Navigator(ui, (SingleComponentContainer)ui);
        ui.setNavigator(navigator);
        navigator.addView("foo", ViewIsNotAComponent.class);
        navigator.navigateTo("foo");
        Assert.assertEquals(HorizontalLayout.class, ui.getContent().getClass());
        Assert.assertEquals((Object)"Hello", (Object)((Label)((HorizontalLayout)ui.getContent()).getComponent(0)).getValue());
    }

    @Test
    public void parameterMap_noViewSeparator() {
        Navigator navigator = this.createNavigatorWithState("fooview");
        Assert.assertTrue((boolean)navigator.getStateParameterMap().isEmpty());
        Assert.assertTrue((boolean)navigator.getStateParameterMap("foo").isEmpty());
    }

    @Test
    public void parameterMap_noParameters() {
        Navigator navigator = this.createNavigatorWithState("fooview/");
        Assert.assertTrue((boolean)navigator.getStateParameterMap().isEmpty());
    }

    @Test
    public void parameterMap_oneParameterNoValue() {
        Navigator navigator = this.createNavigatorWithState("fooview/bar");
        this.assertMap(navigator.getStateParameterMap(), this.entry("bar", ""));
    }

    @Test
    public void parameterMap_oneParameterNoValueButEquals() {
        Navigator navigator = this.createNavigatorWithState("fooview/bar=");
        this.assertMap(navigator.getStateParameterMap(), this.entry("bar", ""));
    }

    @Test
    public void parameterMap_oneParameterWithValue() {
        Navigator navigator = this.createNavigatorWithState("fooview/bar=baz");
        this.assertMap(navigator.getStateParameterMap(), this.entry("bar", "baz"));
    }

    @Test
    public void parameterMap_twoParameters() {
        Navigator navigator = this.createNavigatorWithState("fooview/foo=bar&baz");
        this.assertMap(navigator.getStateParameterMap(), this.entry("foo", "bar"), this.entry("baz", ""));
    }

    @Test
    public void parameterMap_customSeparator() {
        Navigator navigator = this.createNavigatorWithState("fooview/foo=bar&baz");
        this.assertMap(navigator.getStateParameterMap("a"), this.entry("foo", "b"), this.entry("r&b", ""), this.entry("z", ""));
    }

    @SafeVarargs
    private final void assertMap(Map<String, String> map, Map.Entry<String, String> ... entries) {
        Assert.assertEquals((long)entries.length, (long)map.size());
        for (Map.Entry<String, String> entry : entries) {
            Assert.assertTrue((String)("Map should contain a key called '" + entry.getKey() + "'"), (boolean)map.containsKey(entry.getKey()));
            Assert.assertEquals((Object)entry.getValue(), (Object)map.get(entry.getKey()));
        }
    }

    private Map.Entry<String, String> entry(final String key, final String value) {
        return new Map.Entry<String, String>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public String getValue() {
                return value;
            }

            @Override
            public String setValue(String value2) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Navigator createNavigatorWithState(String state) {
        TestNavigationStateManager manager = new TestNavigationStateManager();
        Navigator navigator = new Navigator(NavigatorTest.createMockUI(), (NavigationStateManager)manager, (ViewDisplay)EasyMock.createMock(ViewDisplay.class));
        manager.setState(state);
        return navigator;
    }

    @Test
    public void parameterMapFromViewChangeEvent() {
        Navigator navigator = this.createNavigatorWithState("foo");
        TestView view1 = new TestView();
        TestView view2 = new TestView();
        navigator.addView("view1", (View)view1);
        navigator.addView("view2", (View)view2);
        AtomicReference mapRef = new AtomicReference();
        AtomicReference mapRefB = new AtomicReference();
        navigator.addViewChangeListener((ViewChangeListener & Serializable)event -> {
            mapRef.set(event.getParameterMap());
            mapRefB.set(event.getParameterMap("b"));
            return true;
        });
        navigator.navigateTo("view1");
        Assert.assertTrue((boolean)((Map)mapRef.get()).isEmpty());
        Assert.assertTrue((boolean)((Map)mapRefB.get()).isEmpty());
        navigator.navigateTo("view1/a&b=c&d");
        this.assertMap((Map)mapRef.get(), this.entry("a", ""), this.entry("b", "c"), this.entry("d", ""));
        this.assertMap((Map)mapRefB.get(), this.entry("a&", ""), this.entry("", "c&d"));
    }

    @Test
    public void view_beforeLeave_preventNavigation() {
        Navigator navigator = this.createNavigatorWithState("foo");
        View view1 = new View(){

            public void enter(ViewChangeListener.ViewChangeEvent event) {
            }

            public void beforeLeave(ViewBeforeLeaveEvent event) {
            }
        };
        View view2 = (View)EasyMock.createMock(View.class);
        navigator.addView("view1", view1);
        navigator.addView("view2", view2);
        navigator.navigateTo("view1");
        navigator.navigateTo("view2");
        Assert.assertEquals((Object)"view1", (Object)navigator.getState());
    }

    @Test
    public void view_beforeLeave_allowNavigation() {
        Navigator navigator = this.createNavigatorWithState("foo");
        View view1 = new View(){

            public void enter(ViewChangeListener.ViewChangeEvent event) {
            }

            public void beforeLeave(ViewBeforeLeaveEvent event) {
                event.navigate();
            }
        };
        View view2 = (View)EasyMock.createMock(View.class);
        navigator.addView("view1", view1);
        navigator.addView("view2", view2);
        navigator.navigateTo("view1");
        navigator.navigateTo("view2");
        Assert.assertEquals((Object)"view2", (Object)navigator.getState());
    }

    @Test
    public void view_beforeLeave_delayNavigation() {
        Navigator navigator = this.createNavigatorWithState("foo");
        final AtomicReference eventRef = new AtomicReference();
        View view1 = new View(){

            public void enter(ViewChangeListener.ViewChangeEvent event) {
            }

            public void beforeLeave(ViewBeforeLeaveEvent event) {
                eventRef.set(event);
            }
        };
        View view2 = (View)EasyMock.createMock(View.class);
        navigator.addView("view1", view1);
        navigator.addView("view2", view2);
        navigator.navigateTo("view1");
        navigator.navigateTo("view2");
        Assert.assertEquals((Object)"view1", (Object)navigator.getState());
        ((ViewBeforeLeaveEvent)eventRef.get()).navigate();
        Assert.assertEquals((Object)"view2", (Object)navigator.getState());
    }

    @Test
    public void navigator_invokeBeforeLeaveManually() {
        Navigator navigator = this.createNavigatorWithState("foo");
        final AtomicReference eventRef = new AtomicReference();
        View view1 = new View(){

            public void enter(ViewChangeListener.ViewChangeEvent event) {
            }

            public void beforeLeave(ViewBeforeLeaveEvent event) {
                eventRef.set(event);
            }
        };
        TestView view2 = new TestView();
        navigator.addView("view1", view1);
        navigator.addView("view2", (View)view2);
        navigator.navigateTo("view1");
        AtomicInteger leaveCount = new AtomicInteger(0);
        navigator.runAfterLeaveConfirmation((ViewLeaveAction & Serializable)() -> leaveCount.incrementAndGet());
        Assert.assertEquals((long)0L, (long)leaveCount.get());
        ((ViewBeforeLeaveEvent)eventRef.get()).navigate();
        Assert.assertEquals((long)1L, (long)leaveCount.get());
        Assert.assertEquals((Object)"view1", (Object)navigator.getState());
    }

    public static class ViewIsNotAComponent
    implements View {
        private HorizontalLayout layout = new HorizontalLayout(new Component[]{new Label("Hello")});

        public Component getViewComponent() {
            return this.layout;
        }

        public void enter(ViewChangeListener.ViewChangeEvent event) {
        }
    }

    public static class TestView
    implements View {
        private String params;

        public void enter(ViewChangeListener.ViewChangeEvent event) {
            this.params = event.getParameters();
        }

        public String getParams() {
            return this.params;
        }
    }

    private static class TestPageWithUriFragments
    extends Page {
        private boolean addUriFragmentCalled;
        private boolean removeUriFragmentCalled;

        public TestPageWithUriFragments() {
            super(null, null);
        }

        public Registration addUriFragmentChangedListener(Page.UriFragmentChangedListener listener) {
            this.addUriFragmentCalled = true;
            return (Registration & Serializable)() -> {
                this.removeUriFragmentCalled = true;
            };
        }

        public void removeUriFragmentChangedListener(Page.UriFragmentChangedListener listener) {
            this.removeUriFragmentCalled = true;
        }

        boolean addUriFragmentCalled() {
            return this.addUriFragmentCalled;
        }

        boolean removeUriFragmentCalled() {
            return this.removeUriFragmentCalled;
        }
    }

    private static class TestPage
    extends Page {
        private boolean addPopstateCalled;
        private boolean removePopstateCalled;

        public TestPage() {
            super(null, null);
        }

        public Registration addPopStateListener(Page.PopStateListener listener) {
            this.addPopstateCalled = true;
            return (Registration & Serializable)() -> {
                this.removePopstateCalled = true;
            };
        }

        boolean addPopstateCalled() {
            return this.addPopstateCalled;
        }

        boolean removePopstateCalled() {
            return this.removePopstateCalled;
        }
    }

    @PushStateNavigation
    private static class TestPushStateUI
    extends TestUI {
        TestPushStateUI(Page page) {
            super(page);
        }
    }

    private static class TestUI
    extends UI {
        private final Page page;

        TestUI(Page page) {
            this.page = page;
        }

        protected void init(VaadinRequest request) {
        }

        public Page getPage() {
            return this.page;
        }
    }

    public static class ViewChangeTestListener
    implements ViewChangeListener {
        private final LinkedList<ViewChangeListener.ViewChangeEvent> referenceEvents = new LinkedList();
        private final LinkedList<Boolean> referenceIsCheck = new LinkedList();
        private final LinkedList<Boolean> checkReturnValues = new LinkedList();

        public void addExpectedIsViewChangeAllowed(ViewChangeListener.ViewChangeEvent event, boolean returnValue) {
            this.referenceIsCheck.add(true);
            this.referenceEvents.add(event);
            this.checkReturnValues.add(returnValue);
        }

        public void addExpectedNavigatorViewChange(ViewChangeListener.ViewChangeEvent event) {
            this.referenceIsCheck.add(false);
            this.referenceEvents.add(event);
        }

        public boolean isReady() {
            return this.referenceEvents.isEmpty();
        }

        public boolean equalsReferenceEvent(ViewChangeListener.ViewChangeEvent event, ViewChangeListener.ViewChangeEvent reference) {
            if (event == null) {
                return false;
            }
            if (reference.getNavigator() != event.getNavigator()) {
                return false;
            }
            if (reference.getOldView() != event.getOldView()) {
                return false;
            }
            if (reference.getNewView() != event.getNewView()) {
                return false;
            }
            if (!ViewChangeTestListener.stringEquals(reference.getViewName(), event.getViewName())) {
                return false;
            }
            return ViewChangeTestListener.stringEquals(reference.getParameters(), event.getParameters());
        }

        private static boolean stringEquals(String string1, String string2) {
            if (string1 == null) {
                return string2 == null;
            }
            return string1.equals(string2);
        }

        public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
            if (this.referenceEvents.isEmpty()) {
                Assert.fail((String)"Unexpected call to beforeViewChange()");
            }
            ViewChangeListener.ViewChangeEvent reference = this.referenceEvents.remove();
            Boolean isCheck = this.referenceIsCheck.remove();
            if (!isCheck.booleanValue()) {
                Assert.fail((String)"Expected afterViewChange(), received beforeViewChange()");
            }
            Boolean returnValue = this.checkReturnValues.remove();
            if (!this.equalsReferenceEvent(event, reference)) {
                Assert.fail((String)"View change event does not match reference event");
            }
            return returnValue;
        }

        public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
            if (this.referenceEvents.isEmpty()) {
                Assert.fail((String)"Unexpected call to afterViewChange()");
            }
            ViewChangeListener.ViewChangeEvent reference = this.referenceEvents.remove();
            Boolean isCheck = this.referenceIsCheck.remove();
            if (isCheck.booleanValue()) {
                Assert.fail((String)"Expected beforeViewChange(), received afterViewChange()");
            }
            if (!this.equalsReferenceEvent(event, reference)) {
                Assert.fail((String)"View change event does not match reference event");
            }
        }
    }

    public static class TestNavigatorWithFragments
    extends Navigator {
        public TestNavigatorWithFragments() {
            super(NavigatorTest.createMockUI(), (NavigationStateManager)new NullFragmentManager(), (ViewDisplay)new TestDisplay());
        }

        public TestNavigatorWithFragments(UI ui) {
            super(ui, (NavigationStateManager)new Navigator.UriFragmentManager(ui.getPage()), (ViewDisplay)EasyMock.createMock(ViewDisplay.class));
        }

        public View getView(String viewAndParameters) {
            try {
                this.navigateTo(viewAndParameters);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return ((TestDisplay)this.getDisplay()).getCurrentView();
        }

        protected NavigationStateManager getStateManager() {
            return super.getStateManager();
        }
    }

    public static class TestNavigator
    extends Navigator {
        public TestNavigator() {
            super(NavigatorTest.createMockUI(), (NavigationStateManager)new NullFragmentManager(), (ViewDisplay)new TestDisplay());
        }

        public TestNavigator(UI ui) {
            super(ui, (ViewDisplay)EasyMock.createMock(ViewDisplay.class));
        }

        public View getView(String viewAndParameters) {
            try {
                this.navigateTo(viewAndParameters);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return ((TestDisplay)this.getDisplay()).getCurrentView();
        }

        protected NavigationStateManager getStateManager() {
            return super.getStateManager();
        }
    }

    public static class TestDisplay
    implements ViewDisplay {
        private View currentView;

        public void showView(View view) {
            this.currentView = view;
        }

        public View getCurrentView() {
            return this.currentView;
        }
    }

    public static class NullFragmentManager
    implements NavigationStateManager {
        public String getState() {
            return null;
        }

        public void setState(String fragment) {
        }

        public void setNavigator(Navigator navigator) {
        }
    }

    public static class NullDisplay
    implements ViewDisplay {
        public void showView(View view) {
        }
    }

    private final class TestNavigationStateManager
    implements NavigationStateManager {
        private String state;

        private TestNavigationStateManager() {
        }

        public void setState(String state) {
            this.state = state;
        }

        public void setNavigator(Navigator navigator) {
        }

        public String getState() {
            return this.state;
        }
    }
}

