/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.componentcontainer;

import com.vaadin.shared.ui.orderedlayout.FormLayoutState;
import com.vaadin.tests.server.componentcontainer.AbstractIndexedLayoutTestBase;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;

public class FormLayoutTest
extends AbstractIndexedLayoutTestBase {
    Component[] children = new Component[]{new Label("A"), new Label("B"), new Label("C"), new Label("D")};

    @Override
    protected Layout createLayout() {
        return new FormLayout();
    }

    public FormLayout getLayout() {
        return (FormLayout)super.getLayout();
    }

    @Override
    protected Component getComponent(int index) {
        return this.getLayout().getComponent(index);
    }

    @Override
    protected int getComponentIndex(Component c) {
        return this.getLayout().getComponentIndex(c);
    }

    @Override
    protected int getComponentCount() {
        return this.getLayout().getComponentCount();
    }

    @Test
    public void testConstructorWithComponents() {
        FormLayout l = new FormLayout(this.children);
        this.assertOrder((Layout)l, new int[]{0, 1, 2, 3});
    }

    @Test
    public void testAddComponents() {
        FormLayout l = new FormLayout();
        l.addComponents(this.children);
        this.assertOrder((Layout)l, new int[]{0, 1, 2, 3});
    }

    @Test
    public void getState_formLayoutHasCustomState() {
        TestFormLayout layout = new TestFormLayout();
        FormLayoutState state = layout.getState();
        Assert.assertEquals((String)"Unexpected state class", FormLayoutState.class, state.getClass());
    }

    @Test
    public void getPrimaryStyleName_formLayoutHasCustomPrimaryStyleName() {
        FormLayout layout = new FormLayout();
        FormLayoutState state = new FormLayoutState();
        Assert.assertEquals((String)"Unexpected primary style name", (Object)state.primaryStyleName, (Object)layout.getPrimaryStyleName());
    }

    @Test
    public void formLayoutStateHasCustomPrimaryStyleName() {
        FormLayoutState state = new FormLayoutState();
        Assert.assertEquals((String)"Unexpected primary style name", (Object)"v-formlayout", (Object)state.primaryStyleName);
    }

    private void assertOrder(Layout layout, int[] indices) {
        Iterator i = layout.iterator();
        try {
            for (int index : indices) {
                if (index != -1) {
                    Assert.assertSame((Object)this.children[index], i.next());
                    continue;
                }
                i.next();
            }
            Assert.assertFalse((String)"Too many components in layout", (boolean)i.hasNext());
        }
        catch (NoSuchElementException e) {
            Assert.fail((String)"Too few components in layout");
        }
    }

    private static class TestFormLayout
    extends FormLayout {
        private TestFormLayout() {
        }

        public FormLayoutState getState() {
            return super.getState();
        }
    }
}

