/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.componentcontainer;

import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractIndexedLayoutTestBase {
    private Layout layout;

    protected abstract Layout createLayout();

    @Before
    public void setUp() {
        this.layout = this.createLayout();
    }

    public Layout getLayout() {
        return this.layout;
    }

    @Test
    public void testAddRemoveComponent() {
        Label c1 = new Label();
        Label c2 = new Label();
        this.layout.addComponent((Component)c1);
        Assert.assertEquals((Object)c1, (Object)this.getComponent(0));
        Assert.assertEquals((long)1L, (long)this.getComponentCount());
        this.layout.addComponent((Component)c2);
        Assert.assertEquals((Object)c1, (Object)this.getComponent(0));
        Assert.assertEquals((Object)c2, (Object)this.getComponent(1));
        Assert.assertEquals((long)2L, (long)this.getComponentCount());
        this.layout.removeComponent((Component)c1);
        Assert.assertEquals((Object)c2, (Object)this.getComponent(0));
        Assert.assertEquals((long)1L, (long)this.getComponentCount());
        this.layout.removeComponent((Component)c2);
        Assert.assertEquals((long)0L, (long)this.getComponentCount());
    }

    protected abstract int getComponentCount();

    protected abstract Component getComponent(int var1);

    protected abstract int getComponentIndex(Component var1);

    @Test
    public void testGetComponentIndex() {
        Label c1 = new Label();
        Label c2 = new Label();
        this.layout.addComponent((Component)c1);
        Assert.assertEquals((long)0L, (long)this.getComponentIndex((Component)c1));
        this.layout.addComponent((Component)c2);
        Assert.assertEquals((long)0L, (long)this.getComponentIndex((Component)c1));
        Assert.assertEquals((long)1L, (long)this.getComponentIndex((Component)c2));
        this.layout.removeComponent((Component)c1);
        Assert.assertEquals((long)0L, (long)this.getComponentIndex((Component)c2));
        this.layout.removeComponent((Component)c2);
        Assert.assertEquals((long)-1L, (long)this.getComponentIndex((Component)c2));
        Assert.assertEquals((long)-1L, (long)this.getComponentIndex((Component)c1));
    }

    @Test
    public void testGetComponent() {
        Label c1 = new Label();
        Label c2 = new Label();
        this.layout.addComponent((Component)c1);
        Assert.assertEquals((Object)c1, (Object)this.getComponent(0));
        this.layout.addComponent((Component)c2);
        Assert.assertEquals((Object)c1, (Object)this.getComponent(0));
        Assert.assertEquals((Object)c2, (Object)this.getComponent(1));
        this.layout.removeComponent((Component)c1);
        Assert.assertEquals((Object)c2, (Object)this.getComponent(0));
        this.layout.removeComponent((Component)c2);
        try {
            this.getComponent(0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

