/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.upload;

import com.vaadin.tests.design.DeclarativeTestBase;
import com.vaadin.ui.Upload;
import org.junit.Assert;
import org.junit.Test;

public class UploadDeclarativeTest
extends DeclarativeTestBase<Upload> {
    @Test
    public void testReadBasic() {
        this.testRead(this.getBasicDesign(), this.getBasicExpected());
    }

    @Test
    public void testWriteBasic() {
        this.testWrite(this.getBasicDesign(), this.getBasicExpected());
    }

    private String getBasicDesign() {
        return "<vaadin-upload button-caption='Send the file' tabindex=5 />";
    }

    private Upload getBasicExpected() {
        Upload u = new Upload();
        u.setButtonCaption("Send the file");
        u.setTabIndex(5);
        return u;
    }

    @Test
    public void testReadEmpty() {
        this.testRead("<vaadin-upload />", new Upload());
    }

    @Test
    public void testWriteEmpty() {
        this.testWrite("<vaadin-upload />", new Upload());
    }

    @Test
    public void testImmediateModeDefault() {
        Assert.assertTrue((boolean)this.testRead("<v-upload />", new Upload()).isImmediateMode());
        Upload upload = new Upload();
        upload.setImmediateMode(false);
        Assert.assertFalse((boolean)this.testRead("<v-upload immediate-mode=false />", upload).isImmediateMode());
    }
}

