/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.treegrid;

import com.vaadin.data.TreeData;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.HierarchicalQuery;
import com.vaadin.data.provider.Query;
import com.vaadin.data.provider.TreeDataProvider;
import com.vaadin.tests.data.bean.Person;
import com.vaadin.tests.server.component.abstractlisting.AbstractListingDeclarativeTest;
import com.vaadin.ui.TreeGrid;
import java.lang.reflect.InvocationTargetException;
import org.junit.Assert;

public class TreeGridDeclarativeTest
extends AbstractListingDeclarativeTest<TreeGrid> {
    @Override
    public void dataSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        TreeGrid grid = new TreeGrid();
        Person person1 = this.createPerson("a", "last-name");
        Person person2 = this.createPerson("aa", "last-name");
        Person person3 = this.createPerson("ab", "last-name");
        Person person4 = this.createPerson("b", "last-name");
        Person person5 = this.createPerson("c", "last-name");
        Person person6 = this.createPerson("ca", "last-name");
        Person person7 = this.createPerson("caa", "last-name");
        TreeData data = new TreeData();
        data.addItems(null, (Object[])new Person[]{person1, person4, person5});
        data.addItems((Object)person1, (Object[])new Person[]{person2, person3});
        data.addItem((Object)person5, (Object)person6);
        data.addItem((Object)person6, (Object)person7);
        grid.addColumn(Person::getFirstName).setCaption("First Name");
        grid.addColumn(Person::getLastName).setId("id").setCaption("Id");
        grid.setHierarchyColumn("id");
        grid.setDataProvider((DataProvider)new TreeDataProvider(data));
        String design = String.format("<%s hierarchy-column='id'><table><colgroup><col column-id='column0' sortable><col column-id='id' sortable></colgroup><thead><tr default><th plain-text column-ids='column0'>First Name</th><th plain-text column-ids='id'>Id</th></tr></thead><tbody><tr item='%s'><td>%s</td><td>%s</td></tr><tr item='%s' parent='%s'><td>%s</td><td>%s</td></tr><tr item='%s' parent='%s'><td>%s</td><td>%s</td></tr><tr item='%s'><td>%s</td><td>%s</td></tr><tr item='%s'><td>%s</td><td>%s</td></tr><tr item='%s' parent='%s'><td>%s</td><td>%s</td></tr><tr item='%s' parent='%s'><td>%s</td><td>%s</td></tr></tbody></table></%s>", this.getComponentTag(), person1.toString(), person1.getFirstName(), person1.getLastName(), person2.toString(), person1.toString(), person2.getFirstName(), person2.getLastName(), person3.toString(), person1.toString(), person3.getFirstName(), person3.getLastName(), person4.toString(), person4.getFirstName(), person4.getLastName(), person5.toString(), person5.getFirstName(), person5.getLastName(), person6.toString(), person5.toString(), person6.getFirstName(), person6.getLastName(), person7.toString(), person6.toString(), person7.getFirstName(), person7.getLastName(), this.getComponentTag());
        TreeGrid readGrid = this.testRead(design, grid);
        Assert.assertEquals((long)3L, (long)readGrid.getDataProvider().size((Query)new HierarchicalQuery(null, null)));
        Assert.assertEquals((long)2L, (long)readGrid.getDataProvider().size((Query)new HierarchicalQuery(null, (Object)person1.toString())));
        Assert.assertEquals((long)1L, (long)readGrid.getDataProvider().size((Query)new HierarchicalQuery(null, (Object)person5.toString())));
        Assert.assertEquals((long)1L, (long)readGrid.getDataProvider().size((Query)new HierarchicalQuery(null, (Object)person6.toString())));
        this.testWrite(design, grid, true);
    }

    @Override
    public void valueSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException {
    }

    @Override
    public void readOnlySelection() throws InstantiationException, IllegalAccessException, InvocationTargetException {
    }

    @Override
    protected String getComponentTag() {
        return "vaadin-tree-grid";
    }

    @Override
    protected Class<? extends TreeGrid> getComponentClass() {
        return TreeGrid.class;
    }

    private Person createPerson(String name, String lastName) {
        Person person = new Person(){

            @Override
            public String toString() {
                return this.getFirstName() + " " + this.getLastName();
            }
        };
        person.setFirstName(name);
        person.setLastName(lastName);
        return person;
    }
}

