/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.slider;

import com.vaadin.ui.Slider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public class SliderTest {
    @Test
    public void minCannotBeLargerThanMax() {
        Slider slider = new Slider();
        slider.setMax(100.0);
        slider.setMin(101.0);
        MatcherAssert.assertThat((Object)slider.getMin(), (Matcher)Is.is((Object)101.0));
        MatcherAssert.assertThat((Object)slider.getMax(), (Matcher)Is.is((Object)101.0));
    }

    @Test
    public void maxCannotBeSmallerThanMin() {
        Slider slider = new Slider();
        slider.setMin(50.0);
        slider.setMax(10.0);
        MatcherAssert.assertThat((Object)slider.getMax(), (Matcher)Is.is((Object)10.0));
        MatcherAssert.assertThat((Object)slider.getMin(), (Matcher)Is.is((Object)10.0));
    }

    @Test
    public void valueOutOfBoundsExceptionMessageContainsBounds() {
        Slider slider = new Slider();
        try {
            slider.setValue(Double.valueOf(-1.0));
        }
        catch (Slider.ValueOutOfBoundsException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Value -1.0 is out of bounds: [0.0, 100.0]"));
        }
    }

    @Test
    public void valueIsSet() {
        Slider slider = new Slider();
        slider.setValue(Double.valueOf(5.0));
        MatcherAssert.assertThat((Object)slider.getValue(), (Matcher)Is.is((Object)5.0));
    }

    @Test(expected=Slider.ValueOutOfBoundsException.class)
    public void valueCannotBeOutOfBounds() {
        Slider s = new Slider(0, 10);
        s.setValue(Double.valueOf(20.0));
    }

    @Test
    public void valueCanHaveLargePrecision() {
        Slider slider = new Slider();
        slider.setResolution(20);
        slider.setValue(Double.valueOf(99.01234567891234));
        MatcherAssert.assertThat((Object)slider.getValue(), (Matcher)Is.is((Object)99.01234567891234));
    }

    @Test
    public void doublesCanBeUsedAsLimits() {
        Slider slider = new Slider(1.5, 2.5, 1);
        MatcherAssert.assertThat((Object)slider.getMin(), (Matcher)Is.is((Object)1.5));
        MatcherAssert.assertThat((Object)slider.getValue(), (Matcher)Is.is((Object)1.5));
        MatcherAssert.assertThat((Object)slider.getMax(), (Matcher)Is.is((Object)2.5));
    }

    @Test
    public void valuesGreaterThanIntMaxValueCanBeUsed() {
        double minValue = 2.147483648E9;
        Slider s = new Slider(minValue, minValue + 1.0, 0);
        MatcherAssert.assertThat((Object)s.getValue(), (Matcher)Is.is((Object)minValue));
    }

    @Test
    public void negativeValuesCanBeUsed() {
        Slider slider = new Slider(-0.7, 1.0, 0);
        slider.setValue(Double.valueOf(-0.4));
        MatcherAssert.assertThat((Object)slider.getValue(), (Matcher)Is.is((Object)-0.0));
    }

    @Test
    public void boundariesAreRounded() {
        Slider slider = new Slider(1.5, 2.5, 0);
        slider.setValue(Double.valueOf(1.0));
        MatcherAssert.assertThat((Object)slider.getValue(), (Matcher)Is.is((Object)1.0));
        MatcherAssert.assertThat((Object)slider.getMin(), (Matcher)Is.is((Object)1.0));
        MatcherAssert.assertThat((Object)slider.getMax(), (Matcher)Is.is((Object)2.0));
    }

    @Test
    public void valueWithSmallerPrecisionCanBeUsed() {
        Slider slider = new Slider(0.0, 100.0, 10);
        slider.setValue(Double.valueOf(1.2));
        MatcherAssert.assertThat((Object)slider.getValue(), (Matcher)Is.is((Object)1.2));
    }

    @Test
    public void valueWithLargerPrecisionCanBeUsed() {
        Slider slider = new Slider(0.0, 100.0, 2);
        slider.setValue(Double.valueOf(1.2345));
        MatcherAssert.assertThat((Object)slider.getValue(), (Matcher)Is.is((Object)1.23));
    }

    @Test(expected=NullPointerException.class)
    public void setValue_nullValue_throwNPE() {
        Slider slider = new Slider();
        slider.setValue(null);
    }
}

