/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.link;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.BorderStyle;
import com.vaadin.tests.design.DeclarativeTestBase;
import com.vaadin.ui.Link;
import org.junit.Test;

public class LinkDeclarativeTest
extends DeclarativeTestBase<Link> {
    private String getBasicDesign() {
        return "<vaadin-link href='http://vaadin.com' target='vaadin-window' target-height=500 target-width=800 target-border='none' />";
    }

    private Link getBasicExpected() {
        Link l = new Link();
        l.setResource((Resource)new ExternalResource("http://vaadin.com"));
        l.setTargetName("vaadin-window");
        l.setTargetBorder(BorderStyle.NONE);
        l.setTargetHeight(500);
        l.setTargetWidth(800);
        return l;
    }

    @Test
    public void readBasic() throws Exception {
        this.testRead(this.getBasicDesign(), this.getBasicExpected());
    }

    @Test
    public void writeBasic() throws Exception {
        this.testWrite(this.getBasicDesign(), this.getBasicExpected());
    }

    @Test
    public void testReadEmpty() {
        this.testRead("<vaadin-link />", new Link());
    }

    @Test
    public void testWriteEmpty() {
        this.testWrite("<vaadin-link />", new Link());
    }
}

