/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.label;

import com.vaadin.shared.ui.ContentMode;
import com.vaadin.tests.design.DeclarativeTestBase;
import com.vaadin.ui.Label;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.ui.declarative.DesignFormatter;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class LabelDeclarativeTest
extends DeclarativeTestBase<Label> {
    @Test
    public void testEmpty() {
        String design = "<vaadin-label />";
        Label l = new Label();
        l.setContentMode(ContentMode.HTML);
        this.testRead(design, l);
        this.testWrite(design, l);
    }

    @Test
    public void testDefault() {
        String design = "<vaadin-label>Hello world!</vaadin-label>";
        Label l = this.createLabel("Hello world!", null, true);
        this.testRead(design, l);
        this.testWrite(design, l);
    }

    @Test
    public void testRich() {
        String design = "<vaadin-label>This is <b><u>Rich</u></b> content!</vaadin-label>";
        Label l = this.createLabel("This is \n<b><u>Rich</u></b> content!", null, true);
        this.testRead(design, l);
        this.testWrite(design, l);
    }

    @Test
    public void testPlainText() {
        String design = "<vaadin-label plain-text>This is only &lt;b&gt;text&lt;/b&gt; and will contain visible tags</vaadin-label>";
        Label l = this.createLabel("This is only <b>text</b> and will contain visible tags", null, false);
        this.testRead(design, l);
        this.testWrite(design, l);
    }

    @Test
    public void testContentAndCaption() {
        String design = "<vaadin-label caption='This is a label'>This is <b><u>Rich</u></b> content!</vaadin-label>";
        Label l = this.createLabel("This is \n<b><u>Rich</u></b> content!", "This is a label", true);
        this.testRead(design, l);
        this.testWrite(design, l);
    }

    @Test
    public void testCaption() {
        String design = "<vaadin-label caption='This is a label' />";
        Label l = this.createLabel(null, "This is a label", true);
        this.testRead(design, l);
        this.testWrite(design, l);
    }

    @Test
    public void testHtmlEntities() {
        String design = "<vaadin-label plain-text=\"true\">&gt; Test</vaadin-label>";
        Label read = (Label)this.read(design);
        Assert.assertEquals((Object)"> Test", (Object)read.getValue());
        design = design.replace("plain-text=\"true\"", "");
        read = (Label)this.read(design);
        Assert.assertEquals((Object)"&gt; Test", (Object)read.getValue());
        Label label = new Label("&amp; Test");
        label.setContentMode(ContentMode.TEXT);
        Element root = new Element(Tag.valueOf((String)"vaadin-label"), "");
        label.writeDesign(root, new DesignContext());
        Assert.assertEquals((Object)"&amp;amp; Test", (Object)root.html());
        label.setContentMode(ContentMode.HTML);
        root = new Element(Tag.valueOf((String)"vaadin-label"), "");
        label.writeDesign(root, new DesignContext());
        Assert.assertEquals((Object)"&amp; Test", (Object)root.html());
    }

    @Test
    @Ignore(value="Test ignored due to https://dev.vaadin.com/ticket/19435")
    public void testContentModes() {
        String design = "<vaadin-label caption='This\n is a label' />";
        Label l = this.createLabel(null, "This\n is a label", true);
        l.setContentMode(ContentMode.PREFORMATTED);
        this.testRead(design, l);
        this.testWrite(design, l);
    }

    private Label createLabel(String content, String caption, boolean html) {
        Label label = new Label();
        label.setContentMode(html ? ContentMode.HTML : ContentMode.TEXT);
        if (content != null) {
            label.setValue(content);
        }
        if (caption != null) {
            label.setCaption(DesignFormatter.encodeForTextNode((String)caption));
        }
        return label;
    }
}

