/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.gridlayout;

import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.tests.server.component.DeclarativeMarginTestBase;
import com.vaadin.tests.server.component.gridlayout.PreconfiguredGridLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.declarative.Design;
import com.vaadin.ui.declarative.DesignContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class GridLayoutDeclarativeTest
extends DeclarativeMarginTestBase<GridLayout> {
    @Test
    public void testMargins() {
        this.testMargins("vaadin-grid-layout", new MarginInfo(false));
    }

    @Test
    public void testSimpleGridLayout() {
        Button b1 = new Button("Button 0,0");
        Button b2 = new Button("Button 0,1");
        Button b3 = new Button("Button 1,0");
        Button b4 = new Button("Button 1,1");
        b1.setCaptionAsHtml(true);
        b2.setCaptionAsHtml(true);
        b3.setCaptionAsHtml(true);
        b4.setCaptionAsHtml(true);
        String design = "<vaadin-grid-layout><row><column expand=1.0>" + this.writeChild((Component)b1) + "</column><column expand=3.3>" + this.writeChild((Component)b2) + "</column></row><row><column>" + this.writeChild((Component)b3) + "</column><column>" + this.writeChild((Component)b4) + "</column></row></vaadin-grid-layout>";
        GridLayout gl = new GridLayout(2, 2);
        gl.addComponent((Component)b1);
        gl.addComponent((Component)b2);
        gl.addComponent((Component)b3);
        gl.addComponent((Component)b4);
        gl.setColumnExpandRatio(0, 1.0f);
        gl.setColumnExpandRatio(1, 3.3f);
        this.testWrite(design, gl);
        this.testRead(design, gl);
    }

    @Test
    public void testReadIntegerExpandRatioGridLayout() {
        Button b1 = new Button("Button 0,0");
        b1.setCaptionAsHtml(true);
        String design = "<vaadin-grid-layout><row expand=3><column expand=1>" + this.writeChild((Component)b1) + "</column></row></vaadin-grid-layout>";
        GridLayout gl = new GridLayout(1, 1);
        gl.addComponent((Component)b1);
        gl.setColumnExpandRatio(0, 1.0f);
        gl.setRowExpandRatio(0, 3.0f);
        this.testRead(design, gl);
    }

    @Test
    public void testOneBigComponentGridLayout() {
        Button b1 = new Button("Button 0,0 -&gt; 1,1");
        b1.setCaptionAsHtml(true);
        String design = "<vaadin-grid-layout><row><column colspan=2 rowspan=2>" + this.writeChild((Component)b1) + "</column></row><row expand=2></row></vaadin-grid-layout>";
        GridLayout gl = new GridLayout(2, 2);
        gl.addComponent((Component)b1, 0, 0, 1, 1);
        gl.setRowExpandRatio(1, 2.0f);
        this.testWrite(design, gl);
        this.testRead(design, gl);
    }

    @Test
    public void testMultipleSpannedComponentsGridLayout() {
        GridLayout gl = new GridLayout(5, 5);
        Button b1 = new Button("Button 0,0 -&gt; 0,2");
        b1.setCaptionAsHtml(true);
        gl.addComponent((Component)b1, 0, 0, 2, 0);
        Button b2 = new Button("Button 0,3 -&gt; 3,3");
        b2.setCaptionAsHtml(true);
        gl.addComponent((Component)b2, 3, 0, 3, 3);
        Button b3 = new Button("Button 0,4 -&gt; 1,4");
        b3.setCaptionAsHtml(true);
        gl.addComponent((Component)b3, 4, 0, 4, 1);
        Button b4 = new Button("Button 1,0 -&gt; 3,1");
        b4.setCaptionAsHtml(true);
        gl.addComponent((Component)b4, 0, 1, 1, 3);
        Button b5 = new Button("Button 2,2");
        b5.setCaptionAsHtml(true);
        gl.addComponent((Component)b5, 2, 2);
        Button b6 = new Button("Button 3,4 -&gt; 4,4");
        b6.setCaptionAsHtml(true);
        gl.addComponent((Component)b6, 4, 3, 4, 4);
        Button b7 = new Button("Button 4,1 -&gt; 4,2");
        b7.setCaptionAsHtml(true);
        gl.addComponent((Component)b7, 2, 4, 3, 4);
        String design = "<vaadin-grid-layout><row><column colspan=3>" + this.writeChild((Component)b1) + "</column><column rowspan=4>" + this.writeChild((Component)b2) + "</column><column rowspan=2>" + this.writeChild((Component)b3) + "</column></row><row><column rowspan=3 colspan=2>" + this.writeChild((Component)b4) + "</column></row><row><column>" + this.writeChild((Component)b5) + "</column></row><row><column /><column rowspan=2>" + this.writeChild((Component)b6) + "</column></row><row><column colspan=2 /><column colspan=2>" + this.writeChild((Component)b7) + "</column></row></vaadin-grid-layout>";
        this.testWrite(design, gl);
        this.testRead(design, gl);
    }

    @Test
    public void testManyExtraGridLayoutSlots() {
        GridLayout gl = new GridLayout(5, 5);
        Button b1 = new Button("Button 0,4 -&gt; 4,4");
        b1.setCaptionAsHtml(true);
        gl.addComponent((Component)b1, 4, 0, 4, 4);
        gl.setColumnExpandRatio(2, 2.0f);
        String design = "<vaadin-grid-layout><row><column colspan=4 rowspan=5 expand='0.0,0.0,2.0,0.0' /><column rowspan=5>" + this.writeChild((Component)b1) + "</column></row><row></row><row></row><row></row><row></row></vaadin-grid-layout>";
        this.testWrite(design, gl);
        this.testRead(design, gl);
    }

    @Test
    public void testManyEmptyColumnsWithOneExpand() {
        GridLayout gl = new GridLayout(5, 5);
        Button b1 = new Button("Button 0,4 -&gt; 4,4");
        b1.setCaptionAsHtml(true);
        gl.addComponent((Component)b1, 0, 0, 0, 4);
        gl.setColumnExpandRatio(4, 2.0f);
        String design = "<vaadin-grid-layout><row><column rowspan=5>" + this.writeChild((Component)b1) + "</column><column colspan=4 rowspan=5 expand='0.0,0.0,0.0,2.0' /></row><row></row><row></row><row></row><row></row></vaadin-grid-layout>";
        this.testWrite(design, gl);
        this.testRead(design, gl);
    }

    @Test
    public void testEmptyGridLayout() {
        GridLayout gl = new GridLayout();
        String design = "<vaadin-grid-layout />";
        this.testWrite(design, gl);
        this.testRead(design, gl);
    }

    private String writeChild(Component childComponent) {
        return new DesignContext().createElement(childComponent).toString();
    }

    @Override
    public GridLayout testRead(String design, GridLayout expected) {
        int row;
        expected.setCursorX(0);
        expected.setCursorY(expected.getRows());
        GridLayout result = super.testRead(design, expected);
        for (row = 0; row < expected.getRows(); ++row) {
            Assert.assertEquals((double)expected.getRowExpandRatio(row), (double)result.getRowExpandRatio(row), (double)1.0E-5);
        }
        for (int col = 0; col < expected.getColumns(); ++col) {
            Assert.assertEquals((double)expected.getColumnExpandRatio(col), (double)result.getColumnExpandRatio(col), (double)1.0E-5);
        }
        for (row = 0; row < expected.getRows(); ++row) {
            for (int col = 0; col < expected.getColumns(); ++col) {
                Component eC = expected.getComponent(col, row);
                Component rC = result.getComponent(col, row);
                this.assertEqualsCustom(eC, rC);
                if (eC == null) continue;
                Assert.assertEquals((Object)expected.getComponentAlignment(eC), (Object)result.getComponentAlignment(rC));
            }
        }
        return result;
    }

    @Test
    public void testNestedGridLayouts() {
        String design = "<!DOCTYPE html><html> <body>   <vaadin-grid-layout>    <row>     <column>      <vaadin-grid-layout>       <row>        <column>         <vaadin-button>          Button         </vaadin-button>        </column>       </row>      </vaadin-grid-layout>     </column>    </row>   </vaadin-grid-layout>   </body></html>";
        GridLayout outer = new GridLayout();
        GridLayout inner = new GridLayout();
        Button b = new Button("Button");
        b.setCaptionAsHtml(true);
        inner.addComponent((Component)b);
        outer.addComponent((Component)inner);
        this.testRead(design, outer);
        this.testWrite(design, outer);
    }

    @Test
    public void testEmptyGridLayoutWithColsAndRowsSet() throws IOException {
        GridLayout layout = new GridLayout();
        layout.setRows(2);
        layout.setColumns(2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DesignContext context = new DesignContext();
        context.setRootComponent((Component)layout);
        Design.write((DesignContext)context, (OutputStream)out);
        ByteArrayInputStream input = new ByteArrayInputStream(out.toByteArray());
        Component component = Design.read((InputStream)input);
        GridLayout readLayout = (GridLayout)component;
        Assert.assertEquals((long)layout.getRows(), (long)readLayout.getRows());
    }

    @Test
    public void testGridLayoutAlignments() {
        String design = "<vaadin-grid-layout><row><column><vaadin-label :middle>0</label></column><column><vaadin-label :right>1</label></row><row><column><vaadin-label :bottom :center>2</label></column><column><vaadin-label :middle :center>3</label></row></vaadin-grid-layout>";
        GridLayout gl = new GridLayout(2, 2);
        Alignment[] alignments = new Alignment[]{Alignment.MIDDLE_LEFT, Alignment.TOP_RIGHT, Alignment.BOTTOM_CENTER, Alignment.MIDDLE_CENTER};
        for (int i = 0; i < 4; ++i) {
            Label child = new Label("" + i, ContentMode.HTML);
            gl.addComponent((Component)child);
            gl.setComponentAlignment((Component)child, alignments[i]);
        }
        this.testWrite(design, gl);
        this.testRead(design, gl);
    }

    @Test
    public void testGridLayoutMargins() throws IOException {
        String design = "<vaadin-grid-layout _id=\"marginComponent\"margin><row><column><vaadin-grid-layout _id=\"marginLeftComponent\" margin-left></vaadin-grid-layout></column></row><row><column><vaadin-grid-layout _id=\"marginRightComponent\" margin-right></vaadin-grid-layout></column></row><row><column><vaadin-grid-layout _id=\"marginTopComponent\" margin-top></vaadin-grid-layout></column></row><row><column><vaadin-grid-layout _id=\"marginBottomComponent\" margin-bottom></vaadin-grid-layout></column></row></vaadin-grid-layout>";
        DesignContext context = Design.read((InputStream)new ByteArrayInputStream(design.getBytes(StandardCharsets.UTF_8)), null);
        Assert.assertEquals(null, (Object)context.getCustomAttributes(context.getComponentByLocalId("marginComponent")));
        Assert.assertEquals(null, (Object)context.getCustomAttributes(context.getComponentByLocalId("marginLeftComponent")));
        Assert.assertEquals(null, (Object)context.getCustomAttributes(context.getComponentByLocalId("marginRightComponent")));
        Assert.assertEquals(null, (Object)context.getCustomAttributes(context.getComponentByLocalId("marginTopComponent")));
        Assert.assertEquals(null, (Object)context.getCustomAttributes(context.getComponentByLocalId("marginBottomComponent")));
    }

    @Test
    public void designWithPreconfiguredGridLayout() throws Exception {
        String design = "<html><head><meta name='package-mapping' content='my:com.vaadin.tests.server.component.gridlayout'></meta></head><body><my-preconfigured-grid-layout></my-preconfigured-grid-layout>";
        PreconfiguredGridLayout myLayout = (PreconfiguredGridLayout)Design.read((InputStream)new ByteArrayInputStream(design.getBytes(StandardCharsets.UTF_8)));
        Assert.assertEquals((long)2L, (long)myLayout.getRows());
        Assert.assertEquals((long)2L, (long)myLayout.getColumns());
    }
}

