/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.grid;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValidationException;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.CallbackDataProvider;
import com.vaadin.data.provider.DataCommunicator;
import com.vaadin.data.provider.DataGenerator;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.GridSortOrder;
import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.data.provider.bov.Person;
import com.vaadin.event.SortEvent;
import com.vaadin.event.selection.SelectionEvent;
import com.vaadin.event.selection.SelectionListener;
import com.vaadin.server.SerializableComparator;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.shared.ui.grid.GridState;
import com.vaadin.shared.ui.grid.HeightMode;
import com.vaadin.tests.server.component.grid.TestGrid;
import com.vaadin.tests.util.MockUI;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.TextField;
import com.vaadin.ui.renderers.AbstractRenderer;
import com.vaadin.ui.renderers.NumberRenderer;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import junit.framework.AssertionFailedError;
import org.easymock.Capture;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class GridTest {
    private Grid<String> grid;
    private Grid.Column<String, String> fooColumn;
    private Grid.Column<String, Integer> lengthColumn;
    private Grid.Column<String, Object> objectColumn;
    private Grid.Column<String, String> randomColumn;
    private GridState state;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() {
        this.grid = new Grid<String>(){
            {
                GridTest.this.state = this.getState(false);
            }
        };
        this.fooColumn = this.grid.addColumn(ValueProvider.identity()).setId("foo");
        this.lengthColumn = this.grid.addColumn(String::length, (AbstractRenderer)new NumberRenderer()).setId("length");
        this.objectColumn = this.grid.addColumn((ValueProvider & Serializable)string -> new Object());
        this.randomColumn = this.grid.addColumn(ValueProvider.identity()).setId("randomColumnId");
    }

    @Test
    public void testGridAssistiveCaption() {
        Assert.assertEquals(null, (Object)this.fooColumn.getAssistiveCaption());
        this.fooColumn.setAssistiveCaption("Press Enter to sort.");
        Assert.assertEquals((Object)"Press Enter to sort.", (Object)this.fooColumn.getAssistiveCaption());
    }

    @Test
    public void testCreateGridWithDataCommunicator() {
        DataCommunicator specificDataCommunicator = new DataCommunicator();
        TestGrid<String> grid = new TestGrid<String>(String.class, specificDataCommunicator);
        Assert.assertEquals((Object)specificDataCommunicator, (Object)grid.getDataCommunicator());
    }

    @Test
    public void testGridHeightModeChange() {
        Assert.assertEquals((String)"Initial height mode was not CSS", (Object)HeightMode.CSS, (Object)this.grid.getHeightMode());
        this.grid.setHeightByRows(13.24);
        Assert.assertEquals((String)"Setting height by rows did not change height mode", (Object)HeightMode.ROW, (Object)this.grid.getHeightMode());
        this.grid.setHeight("100px");
        Assert.assertEquals((String)"Setting height did not change height mode.", (Object)HeightMode.CSS, (Object)this.grid.getHeightMode());
    }

    @Test
    public void testFrozenColumnCountTooBig() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("count must be between -1 and the current number of columns (4): 5");
        this.grid.setFrozenColumnCount(5);
    }

    @Test
    public void testFrozenColumnCountTooSmall() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("count must be between -1 and the current number of columns (4): -2");
        this.grid.setFrozenColumnCount(-2);
    }

    @Test
    public void testSetFrozenColumnCount() {
        for (int i = -1; i < 2; ++i) {
            this.grid.setFrozenColumnCount(i);
            Assert.assertEquals((String)"Frozen column count not updated", (long)i, (long)this.grid.getFrozenColumnCount());
        }
    }

    @Test
    public void testGridColumnIdentifier() {
        this.grid.getColumn("foo").setCaption("Bar");
        Assert.assertEquals((String)"Column header not updated correctly", (Object)"Bar", (Object)this.grid.getHeaderRow(0).getCell("foo").getText());
    }

    @Test
    public void testGridMultipleColumnsWithSameIdentifier() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Duplicate ID for columns");
        this.grid.addColumn((ValueProvider & Serializable)t -> t).setId("foo");
    }

    @Test
    public void testAddSelectionListener_singleSelectMode() {
        this.grid.setItems((Object[])new String[]{"foo", "bar", "baz"});
        Capture eventCapture = new Capture();
        this.grid.addSelectionListener((SelectionListener & Serializable)event -> eventCapture.setValue((Object)event));
        this.grid.getSelectionModel().select((Object)"foo");
        SelectionEvent event2 = (SelectionEvent)eventCapture.getValue();
        Assert.assertNotNull((Object)event2);
        Assert.assertFalse((boolean)event2.isUserOriginated());
        Assert.assertEquals((Object)"foo", event2.getFirstSelectedItem().get());
        Assert.assertEquals((Object)"foo", event2.getAllSelectedItems().stream().findFirst().get());
        this.grid.getSelectionModel().select((Object)"bar");
        event2 = (SelectionEvent)eventCapture.getValue();
        Assert.assertNotNull((Object)event2);
        Assert.assertFalse((boolean)event2.isUserOriginated());
        Assert.assertEquals((Object)"bar", event2.getFirstSelectedItem().get());
        Assert.assertEquals((Object)"bar", event2.getAllSelectedItems().stream().findFirst().get());
        this.grid.getSelectionModel().deselect((Object)"bar");
        event2 = (SelectionEvent)eventCapture.getValue();
        Assert.assertNotNull((Object)event2);
        Assert.assertFalse((boolean)event2.isUserOriginated());
        Assert.assertEquals(Optional.empty(), (Object)event2.getFirstSelectedItem());
        Assert.assertEquals((long)0L, (long)event2.getAllSelectedItems().size());
    }

    @Test
    public void testAddSelectionListener_multiSelectMode() {
        this.grid.setItems((Object[])new String[]{"foo", "bar", "baz"});
        this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        Capture eventCapture = new Capture();
        this.grid.addSelectionListener((SelectionListener & Serializable)event -> eventCapture.setValue((Object)event));
        this.grid.getSelectionModel().select((Object)"foo");
        SelectionEvent event2 = (SelectionEvent)eventCapture.getValue();
        Assert.assertNotNull((Object)event2);
        Assert.assertFalse((boolean)event2.isUserOriginated());
        Assert.assertEquals((Object)"foo", event2.getFirstSelectedItem().get());
        Assert.assertEquals((Object)"foo", event2.getAllSelectedItems().stream().findFirst().get());
        this.grid.getSelectionModel().select((Object)"bar");
        event2 = (SelectionEvent)eventCapture.getValue();
        Assert.assertNotNull((Object)event2);
        Assert.assertFalse((boolean)event2.isUserOriginated());
        Assert.assertEquals((Object)"foo", event2.getFirstSelectedItem().get());
        Assert.assertEquals((Object)"foo", event2.getAllSelectedItems().stream().findFirst().get());
        Assert.assertArrayEquals((Object[])new String[]{"foo", "bar"}, (Object[])event2.getAllSelectedItems().toArray(new String[2]));
        this.grid.getSelectionModel().deselect((Object)"foo");
        event2 = (SelectionEvent)eventCapture.getValue();
        Assert.assertNotNull((Object)event2);
        Assert.assertFalse((boolean)event2.isUserOriginated());
        Assert.assertEquals((Object)"bar", event2.getFirstSelectedItem().get());
        Assert.assertEquals((Object)"bar", event2.getAllSelectedItems().stream().findFirst().get());
        Assert.assertArrayEquals((Object[])new String[]{"bar"}, (Object[])event2.getAllSelectedItems().toArray(new String[1]));
        this.grid.getSelectionModel().deselectAll();
        event2 = (SelectionEvent)eventCapture.getValue();
        Assert.assertNotNull((Object)event2);
        Assert.assertFalse((boolean)event2.isUserOriginated());
        Assert.assertEquals(Optional.empty(), (Object)event2.getFirstSelectedItem());
        Assert.assertEquals((long)0L, (long)event2.getAllSelectedItems().size());
    }

    @Test
    public void testAddSelectionListener_noSelectionMode() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("This selection model doesn't allow selection, cannot add selection listeners to it");
        this.grid.setSelectionMode(Grid.SelectionMode.NONE);
        this.grid.addSelectionListener((SelectionListener & Serializable)event -> Assert.fail((String)"never ever happens (tm)"));
    }

    @Test
    public void sortByColumn_sortOrderIsAscendingOneColumn() {
        Grid.Column column = (Grid.Column)this.grid.getColumns().get(1);
        this.grid.sort(column);
        GridSortOrder sortOrder = (GridSortOrder)this.grid.getSortOrder().get(0);
        Assert.assertEquals((Object)column, (Object)sortOrder.getSorted());
        Assert.assertEquals((Object)SortDirection.ASCENDING, (Object)sortOrder.getDirection());
    }

    @Test
    public void sortByColumnDesc_sortOrderIsDescendingOneColumn() {
        Grid.Column column = (Grid.Column)this.grid.getColumns().get(1);
        this.grid.sort(column, SortDirection.DESCENDING);
        GridSortOrder sortOrder = (GridSortOrder)this.grid.getSortOrder().get(0);
        Assert.assertEquals((Object)column, (Object)sortOrder.getSorted());
        Assert.assertEquals((Object)SortDirection.DESCENDING, (Object)sortOrder.getDirection());
    }

    @Test
    public void setSortOrder() {
        Grid.Column column1 = (Grid.Column)this.grid.getColumns().get(1);
        Grid.Column column2 = (Grid.Column)this.grid.getColumns().get(2);
        List<GridSortOrder> order = Arrays.asList(new GridSortOrder(column2, SortDirection.DESCENDING), new GridSortOrder(column1, SortDirection.ASCENDING));
        this.grid.setSortOrder(order);
        List sortOrder = this.grid.getSortOrder();
        Assert.assertEquals((Object)column2, (Object)((GridSortOrder)sortOrder.get(0)).getSorted());
        Assert.assertEquals((Object)SortDirection.DESCENDING, (Object)((GridSortOrder)sortOrder.get(0)).getDirection());
        Assert.assertEquals((Object)column1, (Object)((GridSortOrder)sortOrder.get(1)).getSorted());
        Assert.assertEquals((Object)SortDirection.ASCENDING, (Object)((GridSortOrder)sortOrder.get(1)).getDirection());
    }

    @Test
    public void clearSortOrder() throws Exception {
        Grid.Column column = (Grid.Column)this.grid.getColumns().get(1);
        this.grid.sort(column);
        this.grid.clearSortOrder();
        Assert.assertEquals((long)0L, (long)this.grid.getSortOrder().size());
        Assert.assertEquals((long)0L, (long)this.state.sortColumns.length);
        Assert.assertEquals((long)0L, (long)this.state.sortDirs.length);
    }

    @Test
    public void sortOrderDoesnotContainRemovedColumns() {
        Grid.Column sortColumn = (Grid.Column)this.grid.getColumns().get(1);
        this.grid.sort(sortColumn);
        String id = (String)this.state.columnOrder.get(1);
        Assert.assertEquals((Object)id, (Object)this.state.sortColumns[0]);
        this.grid.removeColumn(sortColumn);
        Assert.assertFalse((String)"Column not removed", (boolean)this.state.columnOrder.contains(id));
        Assert.assertEquals((long)0L, (long)this.state.sortColumns.length);
        Assert.assertEquals((long)0L, (long)this.state.sortDirs.length);
    }

    @Test
    public void sortListener_eventIsFired() {
        Grid.Column column1 = (Grid.Column)this.grid.getColumns().get(1);
        Grid.Column column2 = (Grid.Column)this.grid.getColumns().get(2);
        ArrayList list = new ArrayList();
        AtomicReference<Boolean> fired = new AtomicReference<Boolean>();
        this.grid.addSortListener((SortEvent.SortListener & Serializable)event -> {
            Assert.assertTrue((boolean)list.isEmpty());
            fired.set(true);
            list.addAll(event.getSortOrder());
        });
        this.grid.sort(column1, SortDirection.DESCENDING);
        Assert.assertEquals((Object)column1, (Object)((GridSortOrder)list.get(0)).getSorted());
        Assert.assertEquals((Object)SortDirection.DESCENDING, (Object)((GridSortOrder)list.get(0)).getDirection());
        List<GridSortOrder> order = Arrays.asList(new GridSortOrder(column2, SortDirection.DESCENDING), new GridSortOrder(column1, SortDirection.ASCENDING));
        list.clear();
        this.grid.setSortOrder(order);
        Assert.assertEquals((Object)column2, (Object)((GridSortOrder)list.get(0)).getSorted());
        Assert.assertEquals((Object)SortDirection.DESCENDING, (Object)((GridSortOrder)list.get(0)).getDirection());
        Assert.assertEquals((Object)column1, (Object)((GridSortOrder)list.get(1)).getSorted());
        Assert.assertEquals((Object)SortDirection.ASCENDING, (Object)((GridSortOrder)list.get(1)).getDirection());
        list.clear();
        fired.set(false);
        this.grid.clearSortOrder();
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertTrue((boolean)((Boolean)fired.get()));
    }

    @Test
    public void beanGrid() {
        Grid grid = new Grid(Person.class);
        Grid.Column nameColumn = grid.getColumn("name");
        Grid.Column bornColumn = grid.getColumn("born");
        Assert.assertNotNull((Object)nameColumn);
        Assert.assertNotNull((Object)bornColumn);
        Assert.assertEquals((Object)"Name", (Object)nameColumn.getCaption());
        Assert.assertEquals((Object)"Born", (Object)bornColumn.getCaption());
        JsonObject json = GridTest.getRowData(grid, new Person("Lorem", 2000));
        Set values = Stream.of(json.keys()).map(arg_0 -> ((JsonObject)json).getString(arg_0)).collect(Collectors.toSet());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("Lorem", "2000")), values);
        GridTest.assertSingleSortProperty(nameColumn, "name");
        GridTest.assertSingleSortProperty(bornColumn, "born");
    }

    @Test
    public void beanGrid_editor() throws ValidationException {
        Grid grid = new Grid(Person.class);
        Grid.Column nameColumn = grid.getColumn("name");
        TextField nameField = new TextField();
        nameColumn.setEditorComponent((HasValue)nameField);
        Optional maybeBinding = grid.getEditor().getBinder().getBinding("name");
        Assert.assertTrue((boolean)maybeBinding.isPresent());
        Binder.Binding binding = (Binder.Binding)maybeBinding.get();
        Assert.assertSame((Object)nameField, (Object)binding.getField());
        Person person = new Person("Lorem", 2000);
        grid.getEditor().getBinder().setBean((Object)person);
        Assert.assertEquals((Object)"Lorem", (Object)nameField.getValue());
        nameField.setValue("Ipsum");
        Assert.assertEquals((Object)"Ipsum", (Object)person.getName());
    }

    @Test
    public void oneArgSetEditor_nonBeanGrid() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("A Grid created without a bean type class literal or a custom property set doesn't support finding properties by name.");
        Grid grid = new Grid();
        Grid.Column nameCol = grid.addColumn(Person::getName).setId("name");
        nameCol.setEditorComponent((HasValue)new TextField());
    }

    @Test
    public void addExistingColumnById_throws() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("There is already a column for name");
        Grid grid = new Grid(Person.class);
        grid.addColumn("name");
    }

    @Test
    public void removeByColumn_readdById() {
        Grid grid = new Grid(Person.class);
        grid.removeColumn(grid.getColumn("name"));
        grid.addColumn("name");
        List columns = grid.getColumns();
        Assert.assertEquals((long)2L, (long)columns.size());
        Assert.assertEquals((Object)"born", (Object)((Grid.Column)columns.get(0)).getId());
        Assert.assertEquals((Object)"name", (Object)((Grid.Column)columns.get(1)).getId());
    }

    @Test
    public void removeColumnByColumn() {
        this.grid.removeColumn(this.fooColumn);
        Assert.assertEquals(Arrays.asList(this.lengthColumn, this.objectColumn, this.randomColumn), (Object)this.grid.getColumns());
    }

    @Test
    public void removeColumnByColumn_alreadyRemoved() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Column with id foo cannot be removed from the grid");
        this.grid.removeColumn(this.fooColumn);
        this.grid.removeColumn(this.fooColumn);
        Assert.assertEquals(Arrays.asList(this.lengthColumn, this.objectColumn, this.randomColumn), (Object)this.grid.getColumns());
    }

    @Test
    public void removeColumnById_alreadyRemoved() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("There is no column with the id foo");
        this.grid.removeColumn("foo");
        this.grid.removeColumn("foo");
    }

    @Test
    public void removeColumnById() {
        this.grid.removeColumn("foo");
        Assert.assertEquals(Arrays.asList(this.lengthColumn, this.objectColumn, this.randomColumn), (Object)this.grid.getColumns());
    }

    @Test
    public void removeAllColumns() {
        this.grid.removeAllColumns();
        Assert.assertEquals(Collections.emptyList(), (Object)this.grid.getColumns());
    }

    @Test
    public void removeAllColumnsInGridWithoutColumns() {
        this.grid.removeAllColumns();
        this.grid.removeAllColumns();
        Assert.assertEquals(Collections.emptyList(), (Object)this.grid.getColumns());
    }

    @Test
    public void removeFrozenColumn() {
        this.grid.setFrozenColumnCount(3);
        this.grid.removeColumn(this.fooColumn);
        Assert.assertEquals((long)2L, (long)this.grid.getFrozenColumnCount());
    }

    @Test
    public void removeHiddenFrozenColumn() {
        this.lengthColumn.setHidden(true);
        this.grid.setFrozenColumnCount(3);
        this.grid.removeColumn(this.lengthColumn);
        Assert.assertEquals((long)2L, (long)this.grid.getFrozenColumnCount());
    }

    @Test
    public void removeNonFrozenColumn() {
        this.grid.setFrozenColumnCount(3);
        this.grid.removeColumn(this.randomColumn);
        Assert.assertEquals((long)3L, (long)this.grid.getFrozenColumnCount());
    }

    @Test
    public void testFrozenColumnRemoveColumn() {
        Assert.assertEquals((String)"Grid should not start with a frozen column", (long)0L, (long)this.grid.getFrozenColumnCount());
        int columnCount = this.grid.getColumns().size();
        this.grid.setFrozenColumnCount(columnCount);
        this.grid.removeColumn((Grid.Column)this.grid.getColumns().get(0));
        Assert.assertEquals((String)"Frozen column count should be updated when removing a frozen column", (long)(columnCount - 1), (long)this.grid.getFrozenColumnCount());
    }

    @Test
    public void setColumns_reorder() {
        this.grid.setColumns(new String[]{"length", "foo"});
        List columns = this.grid.getColumns();
        Assert.assertEquals((long)2L, (long)columns.size());
        Assert.assertEquals((Object)"length", (Object)((Grid.Column)columns.get(0)).getId());
        Assert.assertEquals((Object)"foo", (Object)((Grid.Column)columns.get(1)).getId());
    }

    @Test
    public void setColumns_addColumn_notBeangrid() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("A Grid created without a bean type class literal or a custom property set doesn't support finding properties by name.");
        this.grid.setColumns(new String[]{"notHere"});
    }

    @Test
    public void setColumns_addColumns_beangrid() {
        Grid grid = new Grid(Person.class);
        grid.removeColumn("name");
        grid.setColumns(new String[]{"born", "name"});
        List columns = grid.getColumns();
        Assert.assertEquals((long)2L, (long)columns.size());
        Assert.assertEquals((Object)"born", (Object)((Grid.Column)columns.get(0)).getId());
        Assert.assertEquals((Object)"name", (Object)((Grid.Column)columns.get(1)).getId());
    }

    @Test
    public void setColumns_addColumns_v2_beangrid() {
        Grid grid = new Grid(Person.class);
        grid.removeColumn("name");
        ArrayList<String> columnIds = new ArrayList<String>();
        columnIds.add("born");
        columnIds.add("name");
        grid.setColumns(columnIds);
        List columns = grid.getColumns();
        Assert.assertEquals((long)2L, (long)columns.size());
        Assert.assertEquals((Object)"born", (Object)((Grid.Column)columns.get(0)).getId());
        Assert.assertEquals((Object)"name", (Object)((Grid.Column)columns.get(1)).getId());
    }

    @Test
    public void setColumnOrder_byColumn() {
        this.grid.setColumnOrder(new Grid.Column[]{this.randomColumn, this.lengthColumn});
        Assert.assertEquals(Arrays.asList(this.randomColumn, this.lengthColumn, this.fooColumn, this.objectColumn), (Object)this.grid.getColumns());
    }

    @Test
    public void setColumnOrder_byColumn_removedColumn() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("setColumnOrder should not be called with columns that are not in the grid.");
        this.grid.removeColumn(this.randomColumn);
        this.grid.setColumnOrder(new Grid.Column[]{this.randomColumn, this.lengthColumn});
    }

    @Test
    public void setColumnOrder_byString() {
        this.grid.setColumnOrder(new String[]{"randomColumnId", "length"});
        Assert.assertEquals(Arrays.asList(this.randomColumn, this.lengthColumn, this.fooColumn, this.objectColumn), (Object)this.grid.getColumns());
    }

    @Test
    public void setColumnOrder_byString_removedColumn() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("There is no column with the id randomColumnId");
        this.grid.removeColumn("randomColumnId");
        this.grid.setColumnOrder(new String[]{"randomColumnId", "length"});
    }

    @Test
    public void defaultSorting_comparableTypes() {
        GridTest.testValueProviderSorting(1, 2, 3);
    }

    @Test
    public void defaultSorting_strings() {
        GridTest.testValueProviderSorting("a", "b", "c");
    }

    @Test
    public void defaultSorting_notComparable() {
        assert (!Comparable.class.isAssignableFrom(AtomicInteger.class));
        GridTest.testValueProviderSorting(new AtomicInteger(10), new AtomicInteger(8), new AtomicInteger(9));
    }

    @Test
    public void defaultSorting_differentComparables() {
        GridTest.testValueProviderSorting(10.1, 200, 3000.1, 4000);
    }

    @Test
    public void defaultSorting_mutuallyComparableTypes() {
        GridTest.testValueProviderSorting(new java.util.Date(10L), new Date(1000000L), new java.util.Date(100000000L));
    }

    private static void testValueProviderSorting(Object ... expectedOrder) {
        SerializableComparator comparator = new Grid().addColumn(ValueProvider.identity()).getComparator(SortDirection.ASCENDING);
        Assert.assertNotNull((Object)comparator);
        ArrayList<Object> values = new ArrayList<Object>(Arrays.asList(expectedOrder));
        Collections.shuffle(values, new Random(42L));
        Assert.assertArrayEquals((Object[])expectedOrder, (Object[])values.stream().sorted(comparator).toArray());
    }

    @Test
    public void addBeanColumn_validRenderer() {
        Grid grid = new Grid(Person.class);
        grid.removeColumn("born");
        grid.addColumn("born", (AbstractRenderer)new NumberRenderer((NumberFormat)new DecimalFormat("#,###", DecimalFormatSymbols.getInstance(Locale.US))));
        Person person = new Person("Name", 2017);
        JsonObject rowData = GridTest.getRowData(grid, person);
        String formattedValue = Stream.of(rowData.keys()).map(arg_0 -> ((JsonObject)rowData).getString(arg_0)).filter(value -> !value.equals("Name")).findFirst().orElse(null);
        Assert.assertEquals((Object)formattedValue, (Object)"2,017");
    }

    @Test
    public void addBeanColumn_invalidRenderer() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("NumberRenderer");
        this.thrown.expectMessage(" cannot be used with a property of type java.lang.String");
        Grid grid = new Grid(Person.class);
        grid.removeColumn("name");
        grid.addColumn("name", (AbstractRenderer)new NumberRenderer());
    }

    @Test
    public void columnId_sortProperty() {
        GridTest.assertSingleSortProperty(this.lengthColumn, "length");
    }

    @Test
    public void columnId_sortProperty_noId() {
        Assert.assertEquals((long)0L, (long)this.objectColumn.getSortOrder(SortDirection.ASCENDING).count());
    }

    @Test
    public void sortProperty_setId_doesntOverride() {
        this.objectColumn.setSortProperty(new String[]{"foo"});
        this.objectColumn.setId("bar");
        GridTest.assertSingleSortProperty(this.objectColumn, "foo");
    }

    private static void assertSingleSortProperty(Grid.Column<?, ?> column, String expectedProperty) {
        QuerySortOrder[] sortOrders = (QuerySortOrder[])column.getSortOrder(SortDirection.ASCENDING).toArray(QuerySortOrder[]::new);
        Assert.assertEquals((long)1L, (long)sortOrders.length);
        Assert.assertEquals((Object)SortDirection.ASCENDING, (Object)sortOrders[0].getDirection());
        Assert.assertEquals((Object)expectedProperty, (Object)sortOrders[0].getSorted());
    }

    private static <T> JsonObject getRowData(Grid<T> grid, T row) {
        JsonObject json = Json.createObject();
        if (grid.getColumns().isEmpty()) {
            return json;
        }
        new MockUI().setContent((Component)grid);
        Method getter = GridTest.findDataGeneratorGetterMethod();
        grid.getColumns().forEach(column -> {
            try {
                DataGenerator dataGenerator = (DataGenerator)getter.invoke(column, new Object[0]);
                dataGenerator.generateData(row, json);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new AssertionFailedError("Cannot get DataGenerator from Column");
            }
        });
        grid.getUI().setContent(null);
        return json.getObject("d");
    }

    private static Method findDataGeneratorGetterMethod() {
        try {
            Method getter = Grid.Column.class.getDeclaredMethod("getDataGenerator", new Class[0]);
            getter.setAccessible(true);
            return getter;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new AssertionFailedError("Cannot get DataGenerator from Column");
        }
    }

    @Test
    public void removeColumnToThrowForInvalidColumn() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Column with id null cannot be removed from the grid");
        Grid grid1 = new Grid();
        Grid grid2 = new Grid();
        Grid.Column column1 = grid1.addColumn(ValueProvider.identity());
        grid2.removeColumn(column1);
    }

    @Test
    public void testColumnSortable() {
        Grid.Column column = this.grid.addColumn(String::toString);
        this.grid.setItems(Collections.emptyList());
        Assert.assertTrue((String)"Column should be initially sortable", (boolean)column.isSortable());
        Assert.assertTrue((String)"User should be able to sort the column", (boolean)column.isSortableByUser());
        column.setSortable(false);
        Assert.assertFalse((String)"Column should not be sortable", (boolean)column.isSortable());
        Assert.assertFalse((String)"User should not be able to sort the column with in-memory data", (boolean)column.isSortableByUser());
        this.grid.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)q -> Stream.of(new String[0]), (CallbackDataProvider.CountCallback & Serializable)q -> 0));
        Assert.assertFalse((String)"Column should not be sortable", (boolean)column.isSortable());
        Assert.assertFalse((String)"User should not be able to sort the column", (boolean)column.isSortableByUser());
        column.setSortable(true);
        Assert.assertTrue((String)"Column should be marked sortable", (boolean)column.isSortable());
        Assert.assertFalse((String)"User should not be able to sort the column since no sort order is provided", (boolean)column.isSortableByUser());
        column.setSortProperty(new String[]{"toString"});
        Assert.assertTrue((String)"Column should be marked sortable", (boolean)column.isSortable());
        Assert.assertTrue((String)"User should be able to sort the column with the sort order", (boolean)column.isSortableByUser());
    }

    @Test
    public void extendGridCustomDataCommunicator() {
        MyGrid grid = new MyGrid();
    }

    public class MyGrid<T>
    extends Grid<T> {
        public MyGrid() {
            super(new MyDataCommunicator());
        }
    }

    public class MyDataCommunicator<T>
    extends DataCommunicator<T> {
        protected int getMaximumAllowedRows() {
            return 600;
        }
    }
}

