/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.grid;

import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.shared.ui.grid.DropLocation;
import com.vaadin.ui.Grid;
import com.vaadin.ui.components.grid.DropIndexCalculator;
import com.vaadin.ui.components.grid.GridDropEvent;
import com.vaadin.ui.components.grid.GridRowDragger;
import com.vaadin.ui.components.grid.SourceDataProviderUpdater;
import com.vaadin.ui.components.grid.TargetDataProviderUpdater;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridRowDraggerTwoGridsTest {
    private Grid<String> source;
    private Grid<String> target;
    private TestGridRowDragger dragger;
    private List<String> draggedItems;

    @Before
    public void setupListCase() {
        this.source = new Grid();
        this.target = new Grid();
        this.target.addColumn((ValueProvider & Serializable)s -> s).setId("1");
        this.dragger = new TestGridRowDragger(this.source, this.target);
        this.target.setItems((Object[])new String[0]);
    }

    private void drop(String dropIndex, DropLocation dropLocation, String ... items) {
        this.draggedItems = new ArrayList<String>(Arrays.asList(items));
        this.dragger.handleDrop((GridDropEvent<String>)new GridDropEvent(this.target, null, null, null, (Object)dropIndex, dropLocation, null));
    }

    private void verifySourceDataProvider(String ... items) {
        Collection list = ((ListDataProvider)this.source.getDataProvider()).getItems();
        Assert.assertArrayEquals((String)"Invalid items in source data provider", (Object[])items, (Object[])list.toArray());
    }

    private void verifyTargetDataProvider(String ... items) {
        Collection list = ((ListDataProvider)this.target.getDataProvider()).getItems();
        Assert.assertArrayEquals((String)"Invalid items in target data provider", (Object[])items, (Object[])list.toArray());
    }

    private static void setCustomDataProvider(Grid<String> grid) {
        grid.setDataProvider((Grid.FetchItemsCallback & Serializable)(so, i, l) -> null, null);
    }

    private static void setCustomDataProvider(Grid<String> grid, String ... items) {
        grid.setDataProvider((Grid.FetchItemsCallback & Serializable)(so, i, l) -> Stream.of(items), null);
    }

    @Test
    public void listDataProviders_basicOperation() {
        this.source.setItems((Object[])new String[]{"0", "1", "2"});
        this.drop(null, null, "0");
        this.verifySourceDataProvider("1", "2");
        this.verifyTargetDataProvider("0");
        this.drop("0", DropLocation.BELOW, "1");
        this.verifySourceDataProvider("2");
        this.verifyTargetDataProvider("0", "1");
        this.drop("1", DropLocation.ABOVE, "2");
        this.verifySourceDataProvider(new String[0]);
        this.verifyTargetDataProvider("0", "2", "1");
    }

    @Test
    public void listDataProvider_dropAboveFirst() {
        this.source.setItems((Object[])new String[]{"0"});
        this.target.setItems((Object[])new String[]{"1"});
        this.drop("1", DropLocation.ABOVE, "0");
        this.verifySourceDataProvider(new String[0]);
        this.verifyTargetDataProvider("0", "1");
    }

    @Test
    public void listDataProvider_customCalculator() {
        this.source.setItems((Object[])new String[]{"0"});
        this.target.setItems((Object[])new String[]{"1"});
        AtomicInteger trigger = new AtomicInteger();
        this.dragger.setDropIndexCalculator((DropIndexCalculator & Serializable)event -> {
            trigger.incrementAndGet();
            return 0;
        });
        this.drop("1", DropLocation.BELOW, "0");
        Assert.assertEquals((String)"Custom calculator should be invoked", (long)1L, (long)trigger.get());
        this.verifySourceDataProvider(new String[0]);
        this.verifyTargetDataProvider("0", "1");
    }

    @Test
    public void listDataProvider_customCalculatorReturnsMax_droppedToEnd() {
        this.source.setItems((Object[])new String[]{"0"});
        this.target.setItems((Object[])new String[]{"1", "2"});
        this.dragger.setDropIndexCalculator((DropIndexCalculator & Serializable)event -> Integer.MAX_VALUE);
        this.drop("1", DropLocation.ABOVE, "0");
        this.verifySourceDataProvider(new String[0]);
        this.verifyTargetDataProvider("1", "2", "0");
    }

    @Test
    public void customSourceDataProvider_isInvoked() {
        GridRowDraggerTwoGridsTest.setCustomDataProvider(this.source, "0", "1");
        this.target.setItems((Object[])new String[]{"2"});
        AtomicInteger updaterTrigger = new AtomicInteger();
        ArrayList droppedItems = new ArrayList();
        this.dragger.setSourceDataProviderUpdater((SourceDataProviderUpdater & Serializable)(event, dp, items) -> {
            updaterTrigger.incrementAndGet();
            droppedItems.addAll(items);
        });
        this.drop("2", DropLocation.BELOW, "0", "1");
        Assert.assertEquals((String)"source updater not triggered", (long)1L, (long)updaterTrigger.get());
        Assert.assertArrayEquals((Object[])droppedItems.toArray(), (Object[])new Object[]{"0", "1"});
        this.verifyTargetDataProvider("2", "0", "1");
    }

    @Test
    public void noopSourceUpdater() {
        this.source.setItems((Object[])new String[]{"0", "1"});
        this.target.setItems((Object[])new String[]{"2"});
        this.dragger.setSourceDataProviderUpdater(SourceDataProviderUpdater.NOOP);
        this.drop("2", DropLocation.ABOVE, "0", "1");
        this.verifySourceDataProvider("0", "1");
        this.verifyTargetDataProvider("0", "1", "2");
    }

    @Test
    public void alwaysDropToEndCalculator() {
        this.source.setItems((Object[])new String[]{"0"});
        this.target.setItems((Object[])new String[]{"1", "2"});
        this.dragger.setDropIndexCalculator(DropIndexCalculator.alwaysDropToEnd());
        this.drop("1", DropLocation.ABOVE, "0");
        this.verifySourceDataProvider(new String[0]);
        this.verifyTargetDataProvider("1", "2", "0");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void customSourceDataProvider_noCustomSourceUpdater_unsupportedOperationExceptionThrown() {
        GridRowDraggerTwoGridsTest.setCustomDataProvider(this.source);
        this.drop(null, DropLocation.BELOW, "0");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void customTargetDataProvider_noCustomCalculatorAndNoCustomTargetUpdater_unsupportedOperationExceptionThrown() {
        GridRowDraggerTwoGridsTest.setCustomDataProvider(this.target);
        this.drop(null, DropLocation.BELOW, "0");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void customTargetDataProvider_customCalculatorAndNoCustomTargetUpdater_unsupportedOperationExceptionThrown() {
        GridRowDraggerTwoGridsTest.setCustomDataProvider(this.target);
        this.dragger.setDropIndexCalculator((DropIndexCalculator & Serializable)event -> 0);
        this.drop(null, DropLocation.BELOW, "0");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void customTargetDataProvider_noCustomCalculatorAndCustomTargetUpdater_unsupportedOperationExceptionThrown() {
        this.source.setItems((Object[])new String[]{"0"});
        GridRowDraggerTwoGridsTest.setCustomDataProvider(this.target);
        this.dragger.setTargetDataProviderUpdater((TargetDataProviderUpdater & Serializable)(event, dp, index, items) -> {});
        this.drop(null, DropLocation.BELOW, "0");
    }

    @Test
    public void customTargetDataProvider_customCalculatorAndCustomTargetUpdater_triggeredWithMaxIndex() {
        this.source.setItems((Object[])new String[]{"0"});
        GridRowDraggerTwoGridsTest.setCustomDataProvider(this.target, "1", "2", "3");
        AtomicInteger updaterTrigger = new AtomicInteger(-1);
        this.dragger.setTargetDataProviderUpdater((TargetDataProviderUpdater & Serializable)(event, dp, index, items) -> updaterTrigger.set(index));
        AtomicInteger calculatorTrigger = new AtomicInteger();
        this.dragger.setDropIndexCalculator((DropIndexCalculator & Serializable)event -> {
            calculatorTrigger.incrementAndGet();
            return 2;
        });
        this.drop("1", DropLocation.ABOVE, "2");
        Assert.assertEquals((String)"custom calculator not triggered", (long)1L, (long)calculatorTrigger.get());
        Assert.assertEquals((String)"given drop index to target updater is wrong", (long)2L, (long)updaterTrigger.get());
    }

    @Test
    public void dropOnSortedGrid_byDefault_dropsToTheEnd() {
        Assert.assertFalse((String)"Default drops on sorted grid rows should not be allowed", (boolean)this.dragger.getGridDropTarget().isDropAllowedOnRowsWhenSorted());
        this.source.setItems((Object[])new String[]{"0", "1", "2"});
        this.target.setItems((Object[])new String[]{"4", "5"});
        this.target.sort("1");
        this.drop(null, DropLocation.EMPTY, "0");
        this.verifySourceDataProvider("1", "2");
        this.verifyTargetDataProvider("4", "5", "0");
    }

    public class TestGridRowDragger
    extends GridRowDragger<String> {
        public TestGridRowDragger(Grid<String> source, Grid<String> target) {
            super(source, target);
        }

        public void handleDrop(GridDropEvent<String> event) {
            super.handleDrop(event);
        }

        public List<String> getDraggedItems() {
            return GridRowDraggerTwoGridsTest.this.draggedItems;
        }
    }
}

