/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.grid;

import com.vaadin.data.ValueProvider;
import com.vaadin.ui.Grid;
import com.vaadin.ui.components.grid.HeaderRow;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridHeaderFooterTest {
    private Grid<String> grid;

    @Before
    public void setUp() {
        this.grid = new Grid();
    }

    @Test
    public void appendHeaderRow_addedToBottom() {
        HeaderRow defaultRow = this.grid.getHeaderRow(0);
        HeaderRow addedRow = this.grid.appendHeaderRow();
        Assert.assertSame((Object)defaultRow, (Object)this.grid.getHeaderRow(0));
        Assert.assertSame((Object)addedRow, (Object)this.grid.getHeaderRow(1));
    }

    @Test
    public void prependHeaderRow_addedToTop() {
        HeaderRow defaultRow = this.grid.getHeaderRow(0);
        HeaderRow addedRow = this.grid.prependHeaderRow();
        Assert.assertSame((Object)addedRow, (Object)this.grid.getHeaderRow(0));
        Assert.assertSame((Object)defaultRow, (Object)this.grid.getHeaderRow(1));
    }

    @Test
    public void addHeaderRowAtZero_addedToTop() {
        HeaderRow defaultRow = this.grid.getHeaderRow(0);
        HeaderRow addedRow = this.grid.addHeaderRowAt(0);
        Assert.assertSame((Object)addedRow, (Object)this.grid.getHeaderRow(0));
        Assert.assertSame((Object)defaultRow, (Object)this.grid.getHeaderRow(1));
    }

    @Test
    public void addHeaderRowAtRowCount_addedToBottom() {
        HeaderRow defaultRow = this.grid.getHeaderRow(0);
        HeaderRow addedRow = this.grid.addHeaderRowAt(this.grid.getHeaderRowCount());
        Assert.assertSame((Object)defaultRow, (Object)this.grid.getHeaderRow(0));
        Assert.assertSame((Object)addedRow, (Object)this.grid.getHeaderRow(1));
    }

    @Test
    public void removeExistingHeaderRow_removed() {
        HeaderRow defaultRow = this.grid.getHeaderRow(0);
        HeaderRow addedRow = this.grid.appendHeaderRow();
        this.grid.removeHeaderRow(addedRow);
        Assert.assertEquals((long)1L, (long)this.grid.getHeaderRowCount());
        Assert.assertSame((Object)defaultRow, (Object)this.grid.getHeaderRow(0));
    }

    @Test
    public void removeDefaultHeaderRow_removed() {
        HeaderRow defaultRow = this.grid.getHeaderRow(0);
        HeaderRow addedRow = this.grid.appendHeaderRow();
        this.grid.removeHeaderRow(defaultRow);
        Assert.assertEquals((long)1L, (long)this.grid.getHeaderRowCount());
        Assert.assertSame((Object)addedRow, (Object)this.grid.getHeaderRow(0));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getHeaderRowNegativeIndex_throws() {
        this.grid.getHeaderRow(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getHeaderRowIndexTooLarge_throws() {
        this.grid.appendHeaderRow();
        this.grid.getHeaderRow(2);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void addHeaderRowAtNegativeIndex_throws() {
        this.grid.addHeaderRowAt(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void addHeaderRowAtIndexTooLarge_throws() {
        this.grid.addHeaderRowAt(2);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void removeHeaderRowNegativeIndex_throws() {
        this.grid.removeHeaderRow(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void removeHeaderRowIndexTooLarge_throws() {
        this.grid.removeHeaderRow(1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeNonExistingHeaderRow_throws() {
        HeaderRow row = this.grid.getHeaderRow(0);
        try {
            this.grid.removeHeaderRow(row);
        }
        catch (Exception e) {
            Assert.fail((String)("unexpected exception: " + e));
        }
        this.grid.removeHeaderRow(row);
    }

    @Test
    public void addColumn_headerCellAdded() {
        Grid.Column column = this.grid.addColumn(ValueProvider.identity()).setId("Col");
        Assert.assertNotNull((Object)this.grid.getHeaderRow(0).getCell(column));
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeColumn_headerCellRemoved() {
        Grid.Column column = this.grid.addColumn(ValueProvider.identity()).setId("Col");
        this.grid.removeColumn(column);
        this.grid.getHeaderRow(0).getCell(column);
    }
}

