/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.datefield;

import com.vaadin.shared.ui.datefield.DateTimeResolution;
import com.vaadin.tests.server.component.abstractdatefield.AbstractLocalDateTimeFieldDeclarativeTest;
import com.vaadin.ui.Component;
import com.vaadin.ui.InlineDateTimeField;
import com.vaadin.ui.declarative.Design;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import org.junit.Assert;
import org.junit.Test;

public class InlineDateTimeFieldDeclarativeTest
extends AbstractLocalDateTimeFieldDeclarativeTest<InlineDateTimeField> {
    @Test
    public void testInlineDateFieldToFromDesign() throws Exception {
        InlineDateTimeField field = new InlineDateTimeField("Day is", LocalDateTime.of(2003, 2, 27, 4, 13, 45));
        field.setShowISOWeekNumbers(true);
        field.setRangeStart((Temporal)LocalDateTime.of(2001, 2, 27, 6, 12, 53));
        field.setRangeEnd((Temporal)LocalDateTime.of(20011, 2, 27, 3, 43, 23));
        field.setResolution((Enum)DateTimeResolution.SECOND);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Design.write((Component)field, (OutputStream)bos);
        InlineDateTimeField result = (InlineDateTimeField)Design.read((InputStream)new ByteArrayInputStream(bos.toByteArray()));
        Assert.assertEquals((Object)field.getResolution(), (Object)result.getResolution());
        Assert.assertEquals((Object)field.getCaption(), (Object)result.getCaption());
        Assert.assertEquals((Object)field.getValue(), (Object)result.getValue());
        Assert.assertEquals((Object)field.getRangeStart(), (Object)result.getRangeStart());
        Assert.assertEquals((Object)field.getRangeEnd(), (Object)result.getRangeEnd());
    }

    @Override
    protected String getComponentTag() {
        return "vaadin-inline-date-time-field";
    }

    @Override
    protected Class<? extends InlineDateTimeField> getComponentClass() {
        return InlineDateTimeField.class;
    }
}

