/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.datefield;

import com.vaadin.data.validator.DateTimeRangeValidator;
import com.vaadin.data.validator.RangeValidator;
import com.vaadin.event.FieldEvents;
import com.vaadin.shared.ui.datefield.DateTimeResolution;
import com.vaadin.tests.server.component.AbstractListenerMethodsTestBase;
import com.vaadin.ui.AbstractDateField;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Map;
import org.junit.Test;

public class DateFieldListenersTest
extends AbstractListenerMethodsTestBase {
    @Test
    public void testFocusListenerAddGetRemove() throws Exception {
        this.testListenerAddGetRemove(TestDateField.class, FieldEvents.FocusEvent.class, FieldEvents.FocusListener.class);
    }

    @Test
    public void testBlurListenerAddGetRemove() throws Exception {
        this.testListenerAddGetRemove(TestDateField.class, FieldEvents.BlurEvent.class, FieldEvents.BlurListener.class);
    }

    public static class TestDateField
    extends AbstractDateField<LocalDateTime, DateTimeResolution> {
        public TestDateField() {
            super((Enum)DateTimeResolution.DAY);
        }

        protected int getDatePart(LocalDateTime date, DateTimeResolution resolution) {
            return 0;
        }

        protected LocalDateTime buildDate(Map<DateTimeResolution, Integer> resolutionValues) {
            return null;
        }

        protected RangeValidator<LocalDateTime> getRangeValidator() {
            return new DateTimeRangeValidator(this.getDateOutOfRangeMessage(), this.adjustToResolution((LocalDateTime)this.getRangeStart(), (DateTimeResolution)this.getResolution()), this.adjustToResolution((LocalDateTime)this.getRangeEnd(), (DateTimeResolution)this.getResolution()));
        }

        protected LocalDateTime convertFromDate(Date date) {
            return null;
        }

        protected Date convertToDate(LocalDateTime date) {
            return null;
        }

        protected String formatDate(LocalDateTime value) {
            return null;
        }

        protected LocalDateTime toType(TemporalAccessor temporalAccessor) {
            return LocalDateTime.from(temporalAccessor);
        }

        protected LocalDateTime adjustToResolution(LocalDateTime date, DateTimeResolution forResolution) {
            if (date == null) {
                return null;
            }
            switch (forResolution) {
                case YEAR: {
                    return date.withDayOfYear(1).toLocalDate().atStartOfDay();
                }
                case MONTH: {
                    return date.withDayOfMonth(1).toLocalDate().atStartOfDay();
                }
                case DAY: {
                    return date.toLocalDate().atStartOfDay();
                }
                case HOUR: {
                    return date.truncatedTo(ChronoUnit.HOURS);
                }
                case MINUTE: {
                    return date.truncatedTo(ChronoUnit.MINUTES);
                }
                case SECOND: {
                    return date.truncatedTo(ChronoUnit.SECONDS);
                }
            }
            assert (false) : "Unexpected resolution argument " + forResolution;
            return null;
        }
    }
}

