/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.combobox;

import com.vaadin.tests.server.component.abstractsingleselect.AbstractSingleSelectDeclarativeTest;
import com.vaadin.tests.server.component.combobox.ExtendedComboBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.StyleGenerator;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;

public class ComboBoxDeclarativeTest
extends AbstractSingleSelectDeclarativeTest<ComboBox> {
    @Test
    public void comboBoxSpecificPropertiesSerialize() {
        String placeholder = "testPlaceholder";
        boolean textInputAllowed = false;
        int pageLength = 7;
        String popupWidth = "11%";
        boolean emptySelectionAllowed = false;
        String emptySelectionCaption = "foo";
        String design = String.format("<%s placeholder='%s' text-input-allowed='%s' page-length='%d' popup-width='%s' empty-selection-allowed='%s' scroll-to-selected-item empty-selection-caption='%s'/>", this.getComponentTag(), placeholder, textInputAllowed, pageLength, popupWidth, emptySelectionAllowed, emptySelectionCaption);
        ComboBox comboBox = new ComboBox();
        comboBox.setPlaceholder(placeholder);
        comboBox.setTextInputAllowed(textInputAllowed);
        comboBox.setPageLength(pageLength);
        comboBox.setPopupWidth(popupWidth);
        comboBox.setScrollToSelectedItem(true);
        comboBox.setEmptySelectionAllowed(emptySelectionAllowed);
        comboBox.setEmptySelectionCaption(emptySelectionCaption);
        this.testRead(design, comboBox);
        this.testWrite(design, comboBox);
    }

    @Test
    public void extendedComboBox() {
        ExtendedComboBox combo = new ExtendedComboBox();
        String design = "<html><head><meta name='package-mapping' content='com_vaadin_tests_server_component_combobox:com.vaadin.tests.server.component.combobox'></meta></head><body><com_vaadin_tests_server_component_combobox-extended-combo-box></com_vaadin_tests_server_component_combobox-extended-combo-box></body></html>";
        this.testWrite(design, combo);
        this.testRead(design, combo);
    }

    @Test
    public void optionStylesSerialization() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        List<String> items = Arrays.asList("foo", "bar", "foobar");
        String design = String.format("<%s>\n<option item='foo' style='foo-style'>foo</option>\n<option item='bar' style='bar-style'>bar</option><option item='foobar' style='foobar-style'>foobar</option></%s>", this.getComponentTag(), this.getComponentTag());
        ComboBox comboBox = new ComboBox();
        comboBox.setItems(items);
        comboBox.setStyleGenerator((StyleGenerator & Serializable)item -> item + "-style");
        this.testRead(design, comboBox);
        this.testWrite(design, comboBox, true);
    }

    @Override
    protected String getComponentTag() {
        return "vaadin-combo-box";
    }

    @Override
    protected Class<? extends ComboBox> getComponentClass() {
        return ComboBox.class;
    }

    @Override
    protected boolean acceptProperty(Class<?> clazz, Method readMethod, Method writeMethod) {
        Class<?> returnType;
        if (readMethod != null && StyleGenerator.class.equals(returnType = readMethod.getReturnType())) {
            return false;
        }
        return super.acceptProperty(clazz, readMethod, writeMethod);
    }
}

