/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.colorpicker;

import com.vaadin.shared.ui.colorpicker.Color;
import com.vaadin.ui.components.colorpicker.ColorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HexPatternParsingTest {
    @Parameterized.Parameter(value=0)
    public String input;
    @Parameterized.Parameter(value=1)
    public int expectedRed;
    @Parameterized.Parameter(value=2)
    public int expectedGreen;
    @Parameterized.Parameter(value=3)
    public int expectedBlue;
    @Parameterized.Parameter(value=4)
    public boolean expectedMatches;

    @Parameterized.Parameters(name="{index}: textValidHEX({0}) = ({1},{2},{3},{4})")
    public static Collection<Object[]> hexdata() {
        Object[][] validValues = new Object[][]{{"#000000", 0, 0, 0, true}, {"#ffffff", 255, 255, 255, true}, {"#FF00ff", 255, 0, 255, true}, {"#aa90e3", 170, 144, 227, true}, {"#016953", 1, 105, 83, true}, {"#bC64D0", 188, 100, 208, true}, {"#F100FF", 241, 0, 255, true}, {"#F0E9a5", 240, 233, 165, true}, {"#990077", 153, 0, 119, true}};
        Object[][] invalidValues = new Object[][]{{"#0000000", 0, 0, 0, false}, {"#ffgfff", 0, 0, 0, false}, {"#FF10f", 0, 0, 0, false}, {"#aa9", 0, 0, 0, false}, {"#03", 0, 0, 0, false}, {"#aab3c4c", 0, 0, 0, false}, {"#6010", 0, 0, 0, false}, {"#CCCC", 0, 0, 0, false}, {"#9", 0, 0, 0, false}, {"#10 10 10", 0, 0, 0, false}, {"101010", 0, 0, 0, false}, {"#10101q", 0, 0, 0, false}, {"\\s%\\d[0-9]", 0, 0, 0, false}, {"#\\d.*", 0, 0, 0, false}, {"rgb\\(\\.*", 0, 0, 0, false}, {"#\\d\\d\\d", 0, 0, 0, false}, {"#\\d.*", 0, 0, 0, false}, {"", 0, 0, 0, false}, {"hsl(25,25,25)", 0, 0, 0, false}};
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        Collections.addAll(values, validValues);
        Collections.addAll(values, invalidValues);
        return values;
    }

    @Test
    public void testValidHEX() {
        Matcher m = ColorUtil.HEX_PATTERN.matcher(this.input);
        boolean matches = m.matches();
        if (this.expectedMatches) {
            Color c = new Color(this.expectedRed, this.expectedGreen, this.expectedBlue);
            Color c1 = ColorUtil.getHexPatternColor((Matcher)m);
            Assert.assertTrue((boolean)c.equals((Object)c1));
        } else {
            Assert.assertTrue((!matches ? 1 : 0) != 0);
        }
    }
}

