/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.colorpicker;

import com.vaadin.shared.ui.colorpicker.Color;
import com.vaadin.ui.components.colorpicker.ColorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HSLPatternParsingTest {
    @Parameterized.Parameter(value=0)
    public String input;
    @Parameterized.Parameter(value=1)
    public Color expectedColor;
    @Parameterized.Parameter(value=2)
    public boolean expectedMatches;

    @Parameterized.Parameters(name="{index}: testHSLData({0}) = ({1},{2})")
    public static Collection<Object[]> hsldata() {
        Object[][] validValues = new Object[][]{{"hsl(0,0,0)", new Color(Color.HSLtoRGB((int)0, (int)0, (int)0)), true}, {"hsl(0, 0, 0)", new Color(Color.HSLtoRGB((int)0, (int)0, (int)0)), true}, {"hsl(0,0%,0% )", new Color(Color.HSLtoRGB((int)0, (int)0, (int)0)), true}, {"hsl(0 0 0)", new Color(Color.HSLtoRGB((int)0, (int)0, (int)0)), true}, {"hsl(0 0% 0%)", new Color(Color.HSLtoRGB((int)0, (int)0, (int)0)), true}, {"hsl(360,100,100)", new Color(Color.HSLtoRGB((int)360, (int)100, (int)100)), true}, {"hsl(360, 100, 100)", new Color(Color.HSLtoRGB((int)360, (int)100, (int)100)), true}, {"hsl(360, 100%, 100%)", new Color(Color.HSLtoRGB((int)360, (int)100, (int)100)), true}, {"hsl(360 100% 100%)", new Color(Color.HSLtoRGB((int)360, (int)100, (int)100)), true}, {"hsl(20, 10, 10)", new Color(Color.HSLtoRGB((int)20, (int)10, (int)10)), true}, {"hsl(100, 0, 50)", new Color(Color.HSLtoRGB((int)100, (int)0, (int)50)), true}, {"hsl(200, 50, 0)", new Color(Color.HSLtoRGB((int)200, (int)50, (int)0)), true}, {"hsl(200, 50, 05)", new Color(Color.HSLtoRGB((int)200, (int)50, (int)5)), true}};
        Object[][] invalidValues = new Object[][]{{"hsl(361,0,0)", null, false}, {"hsl(-0, 0, 0)", null, false}, {"hsl (100%,0%,0% )", null, false}, {"hsl(0 101 0)", null, false}, {"hsl(0 0% -99%)", null, false}, {"hsl(360,100,10 0)", null, false}, {"hsl(360, 100, 101)", null, false}, {"hsl(360, 110%, 100%)", null, false}, {"hsl(3600 100% 100%)", null, false}, {"hs l(420, 10, 10)", null, false}, {"hsl(100, 0, 5,0)", null, false}, {"hsla(200, 50, 0)", null, false}, {"hsl(0,0,0", null, false}, {"rgb\\(\\.*", null, false}, {"hsl(\\.*)", null, false}, {"#\\d.*", null, false}, {"", null, false}};
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        Collections.addAll(values, validValues);
        Collections.addAll(values, invalidValues);
        return values;
    }

    @Test
    public void testHSLData() {
        Matcher m = ColorUtil.HSL_PATTERN.matcher(this.input);
        boolean matches = m.matches();
        if (this.expectedMatches) {
            Color c1 = ColorUtil.getHSLPatternColor((Matcher)m);
            Assert.assertTrue((boolean)this.expectedColor.equals((Object)c1));
        } else {
            Assert.assertTrue((!matches ? 1 : 0) != 0);
        }
    }
}

