/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.abstractsinglecomponentcontainer;

import com.vaadin.server.MockVaadinSession;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RemoveFromParentLockingTest {
    @Before
    @After
    public void cleanCurrentSession() {
        VaadinSession.setCurrent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VerticalLayout createTestComponent() {
        MockVaadinSession session = new MockVaadinSession(null);
        session.getLockInstance().lock();
        try {
            UI ui = new UI(){

                protected void init(VaadinRequest request) {
                }
            };
            ui.setSession((VaadinSession)session);
            VerticalLayout layout = new VerticalLayout();
            ui.setContent((Component)layout);
            VerticalLayout verticalLayout = layout;
            return verticalLayout;
        }
        finally {
            session.getLockInstance().unlock();
        }
    }

    @Test
    public void attachNoSessionLocked() {
        VerticalLayout testComponent = RemoveFromParentLockingTest.createTestComponent();
        VerticalLayout target = new VerticalLayout();
        try {
            target.addComponent((Component)testComponent);
            throw new AssertionError((Object)"Moving component when not holding its sessions's lock should throw");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"Cannot remove from parent when the session is not locked.", (Object)e.getMessage());
            return;
        }
    }

    @Test
    public void attachSessionLocked() {
        VerticalLayout testComponent = RemoveFromParentLockingTest.createTestComponent();
        VerticalLayout target = new VerticalLayout();
        testComponent.getUI().getSession().getLockInstance().lock();
        target.addComponent((Component)testComponent);
    }

    @Test
    public void crossAttachOtherSessionLocked() {
        VerticalLayout notLockedComponent = RemoveFromParentLockingTest.createTestComponent();
        VerticalLayout lockedComponent = RemoveFromParentLockingTest.createTestComponent();
        lockedComponent.getUI().getSession().getLockInstance().lock();
        VaadinSession.setCurrent((VaadinSession)lockedComponent.getUI().getSession());
        try {
            lockedComponent.addComponent((Component)notLockedComponent);
            throw new AssertionError((Object)"Moving component when not holding its sessions's lock should throw");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"Cannot remove from parent when the session is not locked. Furthermore, there is another locked session, indicating that the component might be about to be moved from one session to another.", (Object)e.getMessage());
            return;
        }
    }

    @Test
    public void crossAttachThisSessionLocked() {
        VerticalLayout notLockedComponent = RemoveFromParentLockingTest.createTestComponent();
        VerticalLayout lockedComponent = RemoveFromParentLockingTest.createTestComponent();
        lockedComponent.getUI().getSession().getLockInstance().lock();
        VaadinSession.setCurrent((VaadinSession)lockedComponent.getUI().getSession());
        try {
            notLockedComponent.addComponent((Component)lockedComponent);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }
}

