/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.abstractdatefield;

import com.vaadin.shared.ui.datefield.DateTimeResolution;
import com.vaadin.tests.server.component.abstractfield.AbstractFieldDeclarativeTest;
import com.vaadin.ui.AbstractLocalDateTimeField;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Locale;
import org.junit.Test;

public abstract class AbstractLocalDateTimeFieldDeclarativeTest<T extends AbstractLocalDateTimeField>
extends AbstractFieldDeclarativeTest<T, LocalDateTime> {
    protected DateTimeFormatter VALUE_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:00", Locale.ROOT);
    protected DateTimeFormatter RANGE_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ROOT);

    @Override
    public void valueDeserialization() throws InstantiationException, IllegalAccessException {
        LocalDateTime value = LocalDateTime.of(2003, 2, 27, 10, 37, 43);
        String design = String.format("<%s value='%s'/>", this.getComponentTag(), this.VALUE_DATE_FORMATTER.format(value));
        AbstractLocalDateTimeField component = (AbstractLocalDateTimeField)this.getComponentClass().newInstance();
        component.setValue((Temporal)value);
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Test
    public void abstractDateFieldAttributesDeserialization() throws InstantiationException, IllegalAccessException {
        boolean showIsoWeeks = true;
        LocalDateTime end = LocalDateTime.of(2019, 2, 27, 10, 37, 43);
        LocalDateTime start = LocalDateTime.of(2001, 2, 27, 23, 12, 34);
        String dateOutOfRange = "test date out of range";
        DateTimeResolution resolution = DateTimeResolution.HOUR;
        String dateFormat = "test format";
        boolean lenient = true;
        String parseErrorMsg = "test parse error";
        String design = String.format("<%s show-iso-week-numbers range-end='%s' range-start='%s' date-out-of-range-message='%s' resolution='%s' date-format='%s' lenient parse-error-message='%s'/>", this.getComponentTag(), this.RANGE_DATE_FORMATTER.format(end), this.RANGE_DATE_FORMATTER.format(start), dateOutOfRange, resolution.name().toLowerCase(Locale.ROOT), dateFormat, parseErrorMsg);
        AbstractLocalDateTimeField component = (AbstractLocalDateTimeField)this.getComponentClass().newInstance();
        component.setShowISOWeekNumbers(showIsoWeeks);
        component.setRangeEnd((Temporal)end);
        component.setRangeStart((Temporal)start);
        component.setDateOutOfRangeMessage(dateOutOfRange);
        component.setResolution((Enum)resolution);
        component.setDateFormat(dateFormat);
        component.setLenient(lenient);
        component.setParseErrorMessage(parseErrorMsg);
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Override
    public void readOnlyValue() throws InstantiationException, IllegalAccessException {
        LocalDateTime value = LocalDateTime.of(2003, 2, 27, 23, 12, 34);
        String design = String.format("<%s value='%s' readonly/>", this.getComponentTag(), this.VALUE_DATE_FORMATTER.format(value));
        AbstractLocalDateTimeField component = (AbstractLocalDateTimeField)this.getComponentClass().newInstance();
        component.setValue((Temporal)value);
        component.setReadOnly(true);
        this.testRead(design, component);
        this.testWrite(design, component);
    }
}

