/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.abstractcomponent;

import com.vaadin.server.AbstractErrorMessage;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.FileResource;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.server.UserError;
import com.vaadin.shared.ui.ErrorLevel;
import com.vaadin.tests.design.DeclarativeTestBase;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.declarative.DesignContext;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractComponentDeclarativeTestBase<T extends AbstractComponent>
extends DeclarativeTestBase<T> {
    protected abstract String getComponentTag();

    protected abstract Class<? extends T> getComponentClass();

    @Test
    public void emptyAbstractComponentDeserialization() throws InstantiationException, IllegalAccessException {
        String design = String.format("<%s/> ", this.getComponentTag());
        AbstractComponent component = (AbstractComponent)this.getComponentClass().newInstance();
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Test
    public void abstractComponentAttributesDeserialization() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String id = "testId";
        String caption = "testCaption";
        boolean captionAsHtml = true;
        String description = "testDescription";
        boolean enabled = false;
        String error = "<div>testError</div>";
        String height = "47%";
        String width = "83px";
        String icon = "img/example.gif";
        Locale locale = new Locale("fi", "FI");
        String primaryStyle = "testPrimaryStyle";
        boolean readOnly = true;
        boolean responsive = true;
        String styleName = "testStyleName";
        boolean visible = false;
        boolean requiredIndicator = true;
        AbstractComponent component = (AbstractComponent)this.getComponentClass().newInstance();
        boolean hasReadOnly = this.callBooleanSetter(readOnly, "setReadOnly", component);
        boolean hasRequiredIndicator = this.callBooleanSetter(requiredIndicator, "setRequiredIndicatorVisible", component);
        String design = String.format("<%s id='%s' caption='%s' caption-as-html description='%s' error='%s' enabled='false' width='%s' height='%s' icon='%s' locale='%s' primary-style-name='%s' %s responsive style-name='%s' visible='false' %s/>", this.getComponentTag(), id, caption, description, error, width, height, icon, locale.toString(), primaryStyle, hasReadOnly ? "readonly" : "", styleName, hasRequiredIndicator ? "required-indicator-visible" : "");
        component.setId(id);
        component.setCaption(caption);
        component.setCaptionAsHtml(captionAsHtml);
        component.setDescription(description);
        component.setEnabled(enabled);
        component.setComponentError((ErrorMessage)new UserError(error, AbstractErrorMessage.ContentMode.HTML, ErrorLevel.ERROR));
        component.setHeight(height);
        component.setWidth(width);
        component.setIcon((Resource)new FileResource(new File(icon)));
        component.setLocale(locale);
        component.setPrimaryStyleName(primaryStyle);
        component.setResponsive(responsive);
        component.setStyleName(styleName);
        component.setVisible(visible);
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    private boolean callBooleanSetter(boolean value, String setterName, T component) throws IllegalAccessException, InvocationTargetException {
        try {
            Method method = component.getClass().getMethod(setterName, Boolean.TYPE);
            method.invoke(component, value);
            return true;
        }
        catch (NoSuchMethodException ignore) {
            return false;
        }
    }

    @Test
    public void externalIcon() throws InstantiationException, IllegalAccessException {
        String url = "http://example.com/example.gif";
        String design = String.format("<%s icon='%s'/>", this.getComponentTag(), url);
        AbstractComponent component = (AbstractComponent)this.getComponentClass().newInstance();
        component.setIcon((Resource)new ExternalResource(url));
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Test
    public void themeIcon() throws InstantiationException, IllegalAccessException {
        String path = "example.gif";
        String design = String.format("<%s icon='theme://%s'/>", this.getComponentTag(), path);
        AbstractComponent component = (AbstractComponent)this.getComponentClass().newInstance();
        component.setIcon((Resource)new ThemeResource(path));
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Test
    public void sizeFullDeserialization() throws InstantiationException, IllegalAccessException {
        String design = String.format("<%s size-full/>", this.getComponentTag());
        AbstractComponent component = (AbstractComponent)this.getComponentClass().newInstance();
        component.setSizeFull();
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Test
    public void widthFullDeserialization() throws InstantiationException, IllegalAccessException {
        String design = String.format("<%s width-full/>", this.getComponentTag());
        AbstractComponent component = (AbstractComponent)this.getComponentClass().newInstance();
        component.setWidth("100%");
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Test
    public void heightFullDeserialization() throws InstantiationException, IllegalAccessException {
        String design = String.format("<%s height-full/>", this.getComponentTag());
        AbstractComponent component = (AbstractComponent)this.getComponentClass().newInstance();
        component.setHeight("100%");
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Test
    public void sizeUndefinedDeserialization() throws InstantiationException, IllegalAccessException {
        String design = String.format("<%s/>", this.getComponentTag());
        AbstractComponent component = (AbstractComponent)this.getComponentClass().newInstance();
        component.setSizeUndefined();
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Test
    public void heightUnderfinedDeserialization() throws InstantiationException, IllegalAccessException {
        String design = String.format("<%s/>", this.getComponentTag());
        AbstractComponent component = (AbstractComponent)this.getComponentClass().newInstance();
        component.setHeightUndefined();
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Test
    public void widthUndefinedDeserialization() throws InstantiationException, IllegalAccessException {
        String design = String.format("<%s/>", this.getComponentTag());
        AbstractComponent component = (AbstractComponent)this.getComponentClass().newInstance();
        component.setWidthUndefined();
        this.testRead(design, component);
        this.testWrite(design, component);
    }

    @Test
    public void testUnknownAttribute() {
        String value = "bar";
        String design = String.format("<%s foo='%s'/>", this.getComponentTag(), value);
        DesignContext context = this.readAndReturnContext(design);
        AbstractComponent label = (AbstractComponent)this.getComponentClass().cast(context.getRootComponent());
        Assert.assertTrue((String)"Custom attribute was preserved in custom attributes", (boolean)context.getCustomAttributes((Component)label).containsKey("foo"));
        this.testWrite(label, design, context);
    }
}

