/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.absolutelayout;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbsoluteLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import org.junit.Assert;
import org.junit.Test;

public class ComponentPositionTest {
    private static final String CSS = "top:7.0px;right:7.0%;bottom:7.0pc;left:7.0em;z-index:7;";
    private static final String PARTIAL_CSS = "top:7.0px;left:7.0em;";
    private static final Float CSS_VALUE = Float.valueOf(7.0f);
    private static final Sizeable.Unit UNIT_UNSET = Sizeable.Unit.PIXELS;

    @Test
    public void testNoPosition() {
        AbsoluteLayout layout = new AbsoluteLayout();
        Button b = new Button();
        layout.addComponent((Component)b);
        Assert.assertNull((Object)layout.getPosition((Component)b).getTopValue());
        Assert.assertNull((Object)layout.getPosition((Component)b).getBottomValue());
        Assert.assertNull((Object)layout.getPosition((Component)b).getLeftValue());
        Assert.assertNull((Object)layout.getPosition((Component)b).getRightValue());
        Assert.assertEquals((Object)UNIT_UNSET, (Object)layout.getPosition((Component)b).getTopUnits());
        Assert.assertEquals((Object)UNIT_UNSET, (Object)layout.getPosition((Component)b).getBottomUnits());
        Assert.assertEquals((Object)UNIT_UNSET, (Object)layout.getPosition((Component)b).getLeftUnits());
        Assert.assertEquals((Object)UNIT_UNSET, (Object)layout.getPosition((Component)b).getRightUnits());
        Assert.assertEquals((long)-1L, (long)layout.getPosition((Component)b).getZIndex());
        Assert.assertEquals((Object)"", (Object)layout.getPosition((Component)b).getCSSString());
    }

    @Test
    public void testFullCss() {
        AbsoluteLayout layout = new AbsoluteLayout();
        Button b = new Button();
        layout.addComponent((Component)b, CSS);
        Assert.assertEquals((Object)CSS_VALUE, (Object)layout.getPosition((Component)b).getTopValue());
        Assert.assertEquals((Object)CSS_VALUE, (Object)layout.getPosition((Component)b).getBottomValue());
        Assert.assertEquals((Object)CSS_VALUE, (Object)layout.getPosition((Component)b).getLeftValue());
        Assert.assertEquals((Object)CSS_VALUE, (Object)layout.getPosition((Component)b).getRightValue());
        Assert.assertEquals((Object)Sizeable.Unit.PIXELS, (Object)layout.getPosition((Component)b).getTopUnits());
        Assert.assertEquals((Object)Sizeable.Unit.PICAS, (Object)layout.getPosition((Component)b).getBottomUnits());
        Assert.assertEquals((Object)Sizeable.Unit.EM, (Object)layout.getPosition((Component)b).getLeftUnits());
        Assert.assertEquals((Object)Sizeable.Unit.PERCENTAGE, (Object)layout.getPosition((Component)b).getRightUnits());
        Assert.assertEquals((long)7L, (long)layout.getPosition((Component)b).getZIndex());
        Assert.assertEquals((Object)CSS, (Object)layout.getPosition((Component)b).getCSSString());
    }

    @Test
    public void testPartialCss() {
        AbsoluteLayout layout = new AbsoluteLayout();
        Button b = new Button();
        layout.addComponent((Component)b, PARTIAL_CSS);
        Assert.assertEquals((Object)CSS_VALUE, (Object)layout.getPosition((Component)b).getTopValue());
        Assert.assertNull((Object)layout.getPosition((Component)b).getBottomValue());
        Assert.assertEquals((Object)CSS_VALUE, (Object)layout.getPosition((Component)b).getLeftValue());
        Assert.assertNull((Object)layout.getPosition((Component)b).getRightValue());
        Assert.assertEquals((Object)Sizeable.Unit.PIXELS, (Object)layout.getPosition((Component)b).getTopUnits());
        Assert.assertEquals((Object)UNIT_UNSET, (Object)layout.getPosition((Component)b).getBottomUnits());
        Assert.assertEquals((Object)Sizeable.Unit.EM, (Object)layout.getPosition((Component)b).getLeftUnits());
        Assert.assertEquals((Object)UNIT_UNSET, (Object)layout.getPosition((Component)b).getRightUnits());
        Assert.assertEquals((long)-1L, (long)layout.getPosition((Component)b).getZIndex());
        Assert.assertEquals((Object)PARTIAL_CSS, (Object)layout.getPosition((Component)b).getCSSString());
    }

    @Test
    public void testPartialCssReset() {
        AbsoluteLayout layout = new AbsoluteLayout();
        Button b = new Button();
        layout.addComponent((Component)b, CSS);
        layout.getPosition((Component)b).setCSSString(PARTIAL_CSS);
        Assert.assertEquals((Object)CSS_VALUE, (Object)layout.getPosition((Component)b).getTopValue());
        Assert.assertNull((Object)layout.getPosition((Component)b).getBottomValue());
        Assert.assertEquals((Object)CSS_VALUE, (Object)layout.getPosition((Component)b).getLeftValue());
        Assert.assertNull((Object)layout.getPosition((Component)b).getRightValue());
        Assert.assertEquals((Object)Sizeable.Unit.PIXELS, (Object)layout.getPosition((Component)b).getTopUnits());
        Assert.assertEquals((Object)UNIT_UNSET, (Object)layout.getPosition((Component)b).getBottomUnits());
        Assert.assertEquals((Object)Sizeable.Unit.EM, (Object)layout.getPosition((Component)b).getLeftUnits());
        Assert.assertEquals((Object)UNIT_UNSET, (Object)layout.getPosition((Component)b).getRightUnits());
        Assert.assertEquals((long)-1L, (long)layout.getPosition((Component)b).getZIndex());
        Assert.assertEquals((Object)PARTIAL_CSS, (Object)layout.getPosition((Component)b).getCSSString());
    }

    @Test
    public void testSetPosition() {
        Float SIZE = Float.valueOf(12.0f);
        AbsoluteLayout layout = new AbsoluteLayout();
        Button b = new Button();
        layout.addComponent((Component)b);
        layout.getPosition((Component)b).setTopValue(SIZE);
        layout.getPosition((Component)b).setRightValue(SIZE);
        layout.getPosition((Component)b).setBottomValue(SIZE);
        layout.getPosition((Component)b).setLeftValue(SIZE);
        layout.getPosition((Component)b).setTopUnits(Sizeable.Unit.CM);
        layout.getPosition((Component)b).setRightUnits(Sizeable.Unit.EX);
        layout.getPosition((Component)b).setBottomUnits(Sizeable.Unit.INCH);
        layout.getPosition((Component)b).setLeftUnits(Sizeable.Unit.MM);
        Assert.assertEquals((Object)SIZE, (Object)layout.getPosition((Component)b).getTopValue());
        Assert.assertEquals((Object)SIZE, (Object)layout.getPosition((Component)b).getRightValue());
        Assert.assertEquals((Object)SIZE, (Object)layout.getPosition((Component)b).getBottomValue());
        Assert.assertEquals((Object)SIZE, (Object)layout.getPosition((Component)b).getLeftValue());
        Assert.assertEquals((Object)Sizeable.Unit.CM, (Object)layout.getPosition((Component)b).getTopUnits());
        Assert.assertEquals((Object)Sizeable.Unit.EX, (Object)layout.getPosition((Component)b).getRightUnits());
        Assert.assertEquals((Object)Sizeable.Unit.INCH, (Object)layout.getPosition((Component)b).getBottomUnits());
        Assert.assertEquals((Object)Sizeable.Unit.MM, (Object)layout.getPosition((Component)b).getLeftUnits());
    }

    @Test
    public void testSetPosition2() {
        Float SIZE = Float.valueOf(12.0f);
        AbsoluteLayout layout = new AbsoluteLayout();
        Button b = new Button();
        layout.addComponent((Component)b);
        layout.getPosition((Component)b).setTop(SIZE, Sizeable.Unit.CM);
        layout.getPosition((Component)b).setRight(SIZE, Sizeable.Unit.EX);
        layout.getPosition((Component)b).setBottom(SIZE, Sizeable.Unit.INCH);
        layout.getPosition((Component)b).setLeft(SIZE, Sizeable.Unit.MM);
        Assert.assertEquals((Object)SIZE, (Object)layout.getPosition((Component)b).getTopValue());
        Assert.assertEquals((Object)SIZE, (Object)layout.getPosition((Component)b).getRightValue());
        Assert.assertEquals((Object)SIZE, (Object)layout.getPosition((Component)b).getBottomValue());
        Assert.assertEquals((Object)SIZE, (Object)layout.getPosition((Component)b).getLeftValue());
        Assert.assertEquals((Object)Sizeable.Unit.CM, (Object)layout.getPosition((Component)b).getTopUnits());
        Assert.assertEquals((Object)Sizeable.Unit.EX, (Object)layout.getPosition((Component)b).getRightUnits());
        Assert.assertEquals((Object)Sizeable.Unit.INCH, (Object)layout.getPosition((Component)b).getBottomUnits());
        Assert.assertEquals((Object)Sizeable.Unit.MM, (Object)layout.getPosition((Component)b).getLeftUnits());
    }

    @Test
    public void testUnsetPosition() {
        AbsoluteLayout layout = new AbsoluteLayout();
        Button b = new Button();
        layout.addComponent((Component)b, CSS);
        layout.getPosition((Component)b).setTopValue(null);
        layout.getPosition((Component)b).setRightValue(null);
        layout.getPosition((Component)b).setBottomValue(null);
        layout.getPosition((Component)b).setLeftValue(null);
        layout.getPosition((Component)b).setZIndex(-1);
        Assert.assertNull((Object)layout.getPosition((Component)b).getTopValue());
        Assert.assertNull((Object)layout.getPosition((Component)b).getBottomValue());
        Assert.assertNull((Object)layout.getPosition((Component)b).getLeftValue());
        Assert.assertNull((Object)layout.getPosition((Component)b).getRightValue());
        Assert.assertEquals((Object)"", (Object)layout.getPosition((Component)b).getCSSString());
    }
}

