/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component;

import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.tests.design.DeclarativeTestBase;
import com.vaadin.ui.Layout;
import org.junit.Assert;

public abstract class DeclarativeMarginTestBase<L extends Layout & Layout.MarginHandler>
extends DeclarativeTestBase<L> {
    protected void testSpacing(String componentTag, boolean defaultSpacing) {
        String design = "<" + componentTag;
        if (!defaultSpacing) {
            design = design + " spacing";
        }
        design = design + " />";
        Layout layout = (Layout)this.read(design);
        Assert.assertTrue((boolean)((Layout.SpacingHandler)layout).isSpacing());
        this.testWrite(design, layout);
        design = "<" + componentTag;
        if (defaultSpacing) {
            design = design + " spacing='false'";
        }
        design = design + " />";
        layout = (Layout)this.read(design);
        Assert.assertFalse((boolean)((Layout.SpacingHandler)layout).isSpacing());
        this.testWrite(design, layout);
    }

    protected void testMargins(String componentTag, MarginInfo defaultMargin) {
        for (int i = 0; i < 16; ++i) {
            boolean top = (i & 1) == 1;
            boolean right = (i & 2) == 2;
            boolean bottom = (i & 4) == 4;
            boolean left = (i & 8) == 8;
            MarginInfo marginToTest = new MarginInfo(top, right, bottom, left);
            String design = this.getMarginTag(componentTag, defaultMargin, marginToTest);
            Layout layout = (Layout)this.read(design);
            Assert.assertEquals((String)("For tag: " + design), (Object)marginToTest, (Object)((Layout.MarginHandler)layout).getMargin());
            this.testWrite(design, layout);
        }
    }

    private String getMarginTag(String componentTag, MarginInfo defaultMargin, MarginInfo marginToTest) {
        String s = "<" + componentTag + " ";
        if (marginToTest.hasAll()) {
            if (!defaultMargin.hasAll()) {
                s = s + "margin ";
            }
        } else if (marginToTest.hasNone()) {
            if (!defaultMargin.hasNone()) {
                s = s + "margin=false ";
            }
        } else {
            if (marginToTest.hasLeft() != defaultMargin.hasLeft()) {
                s = s + this.marginValue("margin-left", defaultMargin.hasLeft());
            }
            if (marginToTest.hasRight() != defaultMargin.hasRight()) {
                s = s + this.marginValue("margin-right", defaultMargin.hasRight());
            }
            if (marginToTest.hasTop() != defaultMargin.hasTop()) {
                s = s + this.marginValue("margin-top", defaultMargin.hasTop());
            }
            if (marginToTest.hasBottom() != defaultMargin.hasBottom()) {
                s = s + this.marginValue("margin-bottom", defaultMargin.hasBottom());
            }
        }
        return s + " />";
    }

    private String marginValue(String prefix, boolean defaultOn) {
        return prefix + (defaultOn ? "=false " : " ");
    }
}

