/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.LegacyCommunicationManager;
import com.vaadin.server.MockServletConfig;
import com.vaadin.server.StreamVariable;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import com.vaadin.ui.ConnectorTracker;
import com.vaadin.ui.UI;
import com.vaadin.ui.Upload;
import javax.servlet.ServletConfig;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StreamVariableMappingTest {
    private static final String variableName = "myName";
    private Upload owner;
    private StreamVariable streamVariable;
    private LegacyCommunicationManager cm;

    @Before
    public void setUp() throws Exception {
        final AlwaysLockedVaadinSession application = new AlwaysLockedVaadinSession(null);
        final UI uI = new UI(){

            protected void init(VaadinRequest request) {
            }

            public VaadinSession getSession() {
                return application;
            }
        };
        this.owner = new Upload(){

            public UI getUI() {
                return uI;
            }
        };
        this.streamVariable = (StreamVariable)EasyMock.createMock(StreamVariable.class);
        this.cm = this.createCommunicationManager();
    }

    @Test
    public void testAddStreamVariable() {
        this.owner.getUI().getConnectorTracker().registerConnector((ClientConnector)this.owner);
        String targetUrl = this.cm.getStreamVariableTargetUrl((ClientConnector)this.owner, variableName, this.streamVariable);
        Assert.assertTrue((boolean)targetUrl.startsWith("app://APP/UPLOAD/-1/" + this.owner.getConnectorId() + "/myName/"));
        ConnectorTracker tracker = this.owner.getUI().getConnectorTracker();
        StreamVariable streamVariable2 = tracker.getStreamVariable(this.owner.getConnectorId(), variableName);
        Assert.assertSame((Object)this.streamVariable, (Object)streamVariable2);
    }

    @Test
    public void testRemoveVariable() {
        ConnectorTracker tracker = this.owner.getUI().getConnectorTracker();
        tracker.registerConnector((ClientConnector)this.owner);
        this.cm.getStreamVariableTargetUrl((ClientConnector)this.owner, variableName, this.streamVariable);
        Assert.assertNotNull((Object)tracker.getStreamVariable(this.owner.getConnectorId(), variableName));
        tracker.cleanStreamVariable(this.owner.getConnectorId(), variableName);
        Assert.assertNull((Object)tracker.getStreamVariable(this.owner.getConnectorId(), variableName));
    }

    private LegacyCommunicationManager createCommunicationManager() throws Exception {
        VaadinServlet servlet = new VaadinServlet();
        servlet.init((ServletConfig)new MockServletConfig());
        VaadinServletService vss = new VaadinServletService(servlet, (DeploymentConfiguration)new MockDeploymentConfiguration());
        servlet.init((ServletConfig)new MockServletConfig());
        return new LegacyCommunicationManager((VaadinSession)new AlwaysLockedVaadinSession((VaadinService)vss));
    }
}

