/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.ClientMethodInvocation;
import com.vaadin.server.JsonCodec;
import com.vaadin.ui.JavaScript;
import com.vaadin.util.ReflectTools;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class ClientMethodSerializationTest {
    private static final Method JAVASCRIPT_CALLBACK_METHOD = ReflectTools.findMethod(JavaScript.JavaScriptCallbackRpc.class, (String)"call", (Class[])new Class[]{String.class, JsonArray.class});
    private static final Method BASIC_PARAMS_CALL_METHOD = ReflectTools.findMethod(ClientMethodSerializationTest.class, (String)"basicParamsMethodForTesting", (Class[])new Class[]{String.class, Integer.class});
    private static final Method NO_PARAMS_CALL_METHOD = ReflectTools.findMethod(ClientMethodSerializationTest.class, (String)"noParamsMethodForTesting", (Class[])new Class[0]);

    public void basicParamsMethodForTesting(String stringParam, Integer integerParam) {
    }

    public void noParamsMethodForTesting() {
    }

    @Test
    public void testClientMethodSerialization_WithJSONArray_ContentStaysSame() throws Exception {
        JsonArray originalArray = Json.createArray();
        originalArray.set(0, "callbackParameter1");
        originalArray.set(1, "callBackParameter2");
        originalArray.set(2, "12345");
        ClientMethodInvocation original = new ClientMethodInvocation(null, "interfaceName", JAVASCRIPT_CALLBACK_METHOD, new Object[]{"callBackMethodName", originalArray});
        ClientMethodInvocation copy = (ClientMethodInvocation)ClientMethodSerializationTest.serializeAndDeserialize((Serializable)original);
        JsonArray copyArray = (JsonArray)copy.getParameters()[1];
        Assert.assertEquals((Object)JsonUtil.stringify((JsonValue)originalArray), (Object)JsonUtil.stringify((JsonValue)copyArray));
    }

    @Test
    public void testClientMethodSerialization_WithBasicParams_NoChanges() throws Exception {
        String stringParam = "a string 123";
        Integer integerParam = 1234567890;
        ClientMethodInvocation original = new ClientMethodInvocation(null, "interfaceName", BASIC_PARAMS_CALL_METHOD, (Object[])new Serializable[]{stringParam, integerParam});
        ClientMethodInvocation copy = (ClientMethodInvocation)ClientMethodSerializationTest.serializeAndDeserialize((Serializable)original);
        String copyString = (String)copy.getParameters()[0];
        Integer copyInteger = (Integer)copy.getParameters()[1];
        Assert.assertEquals((Object)copyString, (Object)stringParam);
        Assert.assertEquals((Object)copyInteger, (Object)integerParam);
    }

    @Test
    public void testClientMethodSerialization_NoParams_NoExceptions() {
        ClientMethodInvocation original = new ClientMethodInvocation(null, "interfaceName", NO_PARAMS_CALL_METHOD, null);
        ClientMethodInvocation copy = (ClientMethodInvocation)ClientMethodSerializationTest.serializeAndDeserialize((Serializable)original);
    }

    private static Serializable serializeAndDeserialize(Serializable input) {
        Serializable output = null;
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bs);
            out.writeObject(input);
            byte[] data = bs.toByteArray();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
            output = (Serializable)in.readObject();
        }
        catch (Exception e) {
            Assert.fail((String)("Exception during serialization/deserialization: " + e.getMessage()));
        }
        return output;
    }

    @Test
    public void testSerializeTwice() {
        String name = "javascriptFunctionName";
        String[] arguments = new String[]{"1", "2", "3"};
        JsonArray args = (JsonArray)JsonCodec.encode((Object)arguments, null, Object[].class, null).getEncodedValue();
        ClientConnector connector = null;
        ClientMethodInvocation original = new ClientMethodInvocation(connector, "interfaceName", JAVASCRIPT_CALLBACK_METHOD, new Object[]{name, args});
        ClientMethodInvocation copy = (ClientMethodInvocation)ClientMethodSerializationTest.serializeAndDeserialize((Serializable)original);
        Assert.assertEquals((Object)copy.getMethodName(), (Object)original.getMethodName());
        Assert.assertEquals((long)copy.getParameters().length, (long)original.getParameters().length);
        for (int i = 0; i < copy.getParameters().length; ++i) {
            Object originalParameter = original.getParameters()[i];
            Object copyParameter = copy.getParameters()[i];
            if (originalParameter instanceof JsonValue) {
                Assert.assertEquals((Object)((JsonValue)originalParameter).toJson(), (Object)((JsonValue)copyParameter).toJson());
                continue;
            }
            Assert.assertEquals((Object)originalParameter, (Object)copyParameter);
        }
    }
}

