/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClasspathHelper {
    public static final String COM_VAADIN_FILE_PREFIX = "com" + File.separatorChar + "vaadin" + File.separatorChar;
    private final Predicate<String> skipClassesFilter;

    public ClasspathHelper(Predicate<String> skipClassesFilter) {
        this.skipClassesFilter = skipClassesFilter;
    }

    public ClasspathHelper() {
        this(fqn -> false);
    }

    public Stream<Class<?>> getVaadinClassesFromClasspath(Predicate<String> classpathFilter, Predicate<Class<?>> classFilter) {
        return ClasspathHelper.getRawClasspathEntries().stream().filter(classpathFilter).map(File::new).map(file -> this.getVaadinClassesFromFile((File)file)).flatMap(Collection::stream).filter(classFilter).filter(cls -> !cls.isSynthetic() && !cls.isAnonymousClass() && !Modifier.isPrivate(cls.getModifiers()));
    }

    public Stream<Class<?>> getVaadinClassesFromClasspath(Predicate<String> classpathFilter) {
        return this.getVaadinClassesFromClasspath(classpathFilter, cls -> true);
    }

    private List<Class<?>> getVaadinClassesFromFile(File classesRoot) {
        try {
            if (classesRoot.isDirectory()) {
                return Files.walk(classesRoot.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toFile().getName().endsWith(".class")).filter(path -> classesRoot.toPath().relativize((Path)path).toString().contains(COM_VAADIN_FILE_PREFIX)).map(path -> this.getClassFromFile((Path)path, classesRoot.toPath())).filter(Objects::nonNull).collect(Collectors.toList());
            }
            if (classesRoot.getName().toLowerCase(Locale.ROOT).endsWith(".jar")) {
                FileSystem fileSystem;
                URI uri = URI.create("jar:" + classesRoot.toURI());
                try {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException e) {
                    fileSystem = null;
                }
                if (fileSystem == null) {
                    fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                Path root = fileSystem.getPath(File.separator, new String[0]);
                return Files.walk(root, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toUri().getSchemeSpecificPart().endsWith(".class")).filter(path -> root.relativize((Path)path).toString().contains(COM_VAADIN_FILE_PREFIX)).map(path -> this.getClassFromFile((Path)path, root)).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> getClassFromFile(Path path, Path root) {
        Path relative = root.relativize(path);
        String name = relative.toString();
        name = name.substring(0, name.length() - ".class".length());
        if (this.skipClassesFilter.test(name = name.replace(File.separatorChar, '.'))) {
            return null;
        }
        try {
            return Class.forName(name, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static final List<String> getRawClasspathEntries() {
        ArrayList<String> locations = new ArrayList<String>();
        String pathSep = System.getProperty("path.separator");
        String classpath = System.getProperty("java.class.path");
        if (classpath.startsWith("\"")) {
            classpath = classpath.substring(1);
        }
        if (classpath.endsWith("\"")) {
            classpath = classpath.substring(0, classpath.length() - 1);
        }
        for (String classpathEntry : classpath.split(pathSep)) {
            locations.add(classpathEntry);
        }
        return locations;
    }
}

