/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.event.dnd;

import com.vaadin.shared.ui.dnd.DropEffect;
import com.vaadin.shared.ui.dnd.EffectAllowed;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.dnd.DragSourceExtension;
import com.vaadin.ui.dnd.DropTargetExtension;
import com.vaadin.ui.dnd.event.DragEndListener;
import com.vaadin.ui.dnd.event.DragStartListener;
import com.vaadin.ui.dnd.event.DropListener;
import java.io.Serializable;
import java.util.Optional;

public class DragAndDropBookExamples {
    public void dragSourceExtensionSamples() {
        Label draggableLabel = new Label("You can grab and drag me");
        DragSourceExtension dragSource = new DragSourceExtension((AbstractComponent)draggableLabel);
        dragSource.setEffectAllowed(EffectAllowed.MOVE);
        dragSource.setDataTransferText("hello receiver");
        dragSource.addDragStartListener((DragStartListener & Serializable)event -> ((Label)event.getComponent()).addStyleName("dragged"));
        dragSource.addDragEndListener((DragEndListener & Serializable)event -> ((Label)event.getComponent()).removeStyleName("dragged"));
    }

    public void dropTargetExtensionSamples() {
        VerticalLayout dropTargetLayout = new VerticalLayout();
        dropTargetLayout.setCaption("Drop things inside me");
        dropTargetLayout.addStyleName("card");
        DropTargetExtension dropTarget = new DropTargetExtension((AbstractComponent)dropTargetLayout);
        dropTarget.setDropEffect(DropEffect.MOVE);
        dropTarget.addDropListener((DropListener & Serializable)event -> {
            Optional dragSource = event.getDragSourceComponent();
            if (dragSource.isPresent() && dragSource.get() instanceof Label) {
                dropTargetLayout.addComponent((Component)dragSource.get());
                String message = event.getDataTransferText();
                Notification.show((String)("DropEvent with data transfer: " + message));
            }
        });
    }
}

