/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.event;

import com.vaadin.event.ConnectorEvent;
import com.vaadin.event.MarkedAsDirtyConnectorEvent;
import com.vaadin.event.MarkedAsDirtyListener;
import com.vaadin.server.ClientConnector;
import com.vaadin.tests.util.MockUI;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentTest;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class MarkAsDirtyListenerTest {
    @Test
    public void fire_event_when_ui_marked_dirty() {
        MockUI ui = new MockUI();
        AtomicReference events = new AtomicReference();
        ui.getConnectorTracker().addMarkedAsDirtyListener((MarkedAsDirtyListener & Serializable)event -> Assert.assertTrue((String)"No reference should have been registered", (boolean)events.compareAndSet(null, event)));
        ComponentTest.syncToClient((AbstractComponent)ui);
        ui.getConnectorTracker().markDirty((ClientConnector)ui);
        Assert.assertNotNull((String)"Mark as dirty event should have fired", events.get());
        Assert.assertEquals((String)"Event contains wrong ui", (Object)((Object)ui), (Object)((MarkedAsDirtyConnectorEvent)events.get()).getUi());
        Assert.assertEquals((String)"Found wrong connector in event", (Object)((Object)ui), (Object)((MarkedAsDirtyConnectorEvent)events.get()).getConnector());
    }

    @Test
    public void fire_event_for_setContent() {
        final ArrayList events = new ArrayList();
        MockUI ui = new MockUI(){
            {
                this.getConnectorTracker().addMarkedAsDirtyListener((MarkedAsDirtyListener & Serializable)event -> events.add(event));
            }
        };
        ComponentTest.syncToClient((AbstractComponent)ui);
        Button button = new Button("Button");
        ui.setContent((Component)button);
        Assert.assertEquals((String)"Mark as dirty events should have fired", (long)2L, (long)events.size());
        Assert.assertEquals((String)"Expected button to inform first for creation", (Object)button, (Object)((MarkedAsDirtyConnectorEvent)events.get(0)).getConnector());
        Assert.assertEquals((String)"Expected UI marked as dirty for setContent", (Object)((Object)ui), (Object)((MarkedAsDirtyConnectorEvent)events.get(1)).getConnector());
    }

    @Test
    public void fire_event_for_component_stateChange() {
        MockUI ui = new MockUI();
        Button button = new Button("empty");
        ui.setContent((Component)button);
        ComponentTest.syncToClient((AbstractComponent)button);
        AtomicReference events = new AtomicReference();
        ui.getConnectorTracker().addMarkedAsDirtyListener((MarkedAsDirtyListener & Serializable)event -> Assert.assertTrue((String)"No reference should have been registered", (boolean)events.compareAndSet(null, event)));
        button.setIconAlternateText("alternate");
        Assert.assertNotNull((String)"Mark as dirty event should have fired", events.get());
        Assert.assertEquals((String)"Event contains wrong ui", (Object)((Object)ui), (Object)((MarkedAsDirtyConnectorEvent)events.get()).getUi());
        Assert.assertEquals((String)"Found wrong connector in event", (Object)button, (Object)((MarkedAsDirtyConnectorEvent)events.get()).getConnector());
    }

    @Test
    public void fire_events_for_each_component() {
        final ArrayList events = new ArrayList();
        MockUI ui = new MockUI(){
            {
                this.getConnectorTracker().addMarkedAsDirtyListener((MarkedAsDirtyListener & Serializable)event -> events.add(event));
            }
        };
        HorizontalLayout layout = new HorizontalLayout();
        ui.setContent((Component)layout);
        TextField field = new TextField("Name");
        Button button = new Button("say hello");
        layout.addComponents(new Component[]{field, button});
        Assert.assertFalse((String)"Mark as dirty event should have fired", (boolean)events.isEmpty());
        Assert.assertEquals((String)"Unexpected amount of connector events", (long)3L, (long)events.size());
        Set connectors = events.stream().map(ConnectorEvent::getConnector).collect(Collectors.toSet());
        Assert.assertTrue((String)"HorizontalLayout should have fired an markedAsDirty event", (boolean)connectors.contains(layout));
        Assert.assertTrue((String)"TextField should have fired an markedAsDirty event", (boolean)connectors.contains(field));
        Assert.assertTrue((String)"Button should have fired an markedAsDirty event", (boolean)connectors.contains(button));
    }

    @Test
    public void event_should_only_fire_once_for_an_connector_per_roundtrip() {
        MockUI ui = new MockUI();
        Button button = new Button("empty");
        ui.setContent((Component)button);
        ComponentTest.syncToClient((AbstractComponent)button);
        AtomicReference events = new AtomicReference();
        ui.getConnectorTracker().addMarkedAsDirtyListener((MarkedAsDirtyListener & Serializable)event -> Assert.assertTrue((String)"Only one event should have registered", (boolean)events.compareAndSet(null, event)));
        button.setIconAlternateText("alternate");
        button.setCaption("Update");
        button.setDisableOnClick(true);
        Assert.assertNotNull((String)"Mark as dirty event should have fired", events.get());
        Assert.assertEquals((String)"Event contains wrong ui", (Object)((Object)ui), (Object)((MarkedAsDirtyConnectorEvent)events.get()).getUi());
        Assert.assertEquals((String)"Found wrong connector in event", (Object)button, (Object)((MarkedAsDirtyConnectorEvent)events.get()).getConnector());
        events.set(null);
        ComponentTest.syncToClient((AbstractComponent)button);
        button.setCaption("new caption");
        Assert.assertNotNull((String)"Mark as dirty event should have fired", events.get());
        Assert.assertEquals((String)"Found wrong connector in event", (Object)button, (Object)((MarkedAsDirtyConnectorEvent)events.get()).getConnector());
    }
}

