/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.event;

import com.vaadin.event.EventRouter;
import com.vaadin.event.MouseEvents;
import com.vaadin.event.SerializableEventListener;
import com.vaadin.server.ErrorEvent;
import com.vaadin.server.ErrorHandler;
import com.vaadin.shared.Registration;
import com.vaadin.shared.communication.SharedState;
import com.vaadin.ui.Component;
import com.vaadin.util.ReflectTools;
import java.lang.reflect.Method;
import java.util.EventObject;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EventRouterTest {
    private static final Method COMPONENT_EVENT_METHOD = ReflectTools.findMethod(Component.Listener.class, (String)"componentEvent", (Class[])new Class[]{Component.Event.class});
    private EventRouter router;
    private Component component;
    private ErrorHandler errorHandler;
    private Component.Listener listener;

    @Before
    public void createMocks() {
        this.router = new EventRouter();
        this.component = (Component)EasyMock.createNiceMock(Component.class);
        this.errorHandler = (ErrorHandler)EasyMock.createMock(ErrorHandler.class);
        this.listener = (Component.Listener)EasyMock.createMock(Component.Listener.class);
        this.router.addListener(Component.Event.class, (SerializableEventListener)this.listener, COMPONENT_EVENT_METHOD);
    }

    @Test
    public void fireEvent_noException_eventReceived() {
        this.listener.componentEvent((Component.Event)EasyMock.anyObject());
        EasyMock.replay((Object[])new Object[]{this.component, this.listener, this.errorHandler});
        this.router.fireEvent((EventObject)new Component.Event(this.component), this.errorHandler);
        EasyMock.verify((Object[])new Object[]{this.listener, this.errorHandler});
    }

    @Test
    public void fireEvent_exceptionFromListenerAndNoHandler_exceptionPropagated() {
        this.listener.componentEvent((Component.Event)EasyMock.anyObject());
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("listener failed"));
        EasyMock.replay((Object[])new Object[]{this.component, this.listener});
        try {
            this.router.fireEvent((EventObject)new Component.Event(this.component));
            Assert.fail((String)"Did not receive expected exception from listener");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"listener failed", (Object)e.getCause().getMessage());
        }
        EasyMock.verify((Object[])new Object[]{this.listener});
    }

    @Test
    public void fireEvent_exceptionFromListener_errorHandlerCalled() {
        this.listener.componentEvent((Component.Event)EasyMock.anyObject());
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("listener failed"));
        this.errorHandler.error((ErrorEvent)EasyMock.anyObject());
        EasyMock.replay((Object[])new Object[]{this.component, this.listener, this.errorHandler});
        this.router.fireEvent((EventObject)new Component.Event(this.component), this.errorHandler);
        EasyMock.verify((Object[])new Object[]{this.listener, this.errorHandler});
    }

    @Test
    public void fireEvent_multipleListenersAndException_errorHandlerCalled() {
        Component.Listener listener2 = (Component.Listener)EasyMock.createMock(Component.Listener.class);
        this.router.addListener(Component.Event.class, (SerializableEventListener)listener2, COMPONENT_EVENT_METHOD);
        this.listener.componentEvent((Component.Event)EasyMock.anyObject());
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("listener failed"));
        this.errorHandler.error((ErrorEvent)EasyMock.anyObject());
        listener2.componentEvent((Component.Event)EasyMock.anyObject());
        EasyMock.replay((Object[])new Object[]{this.component, this.listener, listener2, this.errorHandler});
        this.router.fireEvent((EventObject)new Component.Event(this.component), this.errorHandler);
        EasyMock.verify((Object[])new Object[]{this.listener, listener2, this.errorHandler});
    }

    @Test
    public void registrationToRemoveRegisteredEventListener() {
        SharedState state = new SharedState();
        Component.Listener listener2 = (Component.Listener)EasyMock.createMock(Component.Listener.class);
        Registration registration = this.router.addListener(MouseEvents.ClickEvent.class, (SerializableEventListener)listener2, COMPONENT_EVENT_METHOD, "click", state);
        Assert.assertTrue((!state.registeredEventListeners.isEmpty() ? 1 : 0) != 0);
        registration.remove();
        Assert.assertNull((Object)state.registeredEventListeners);
    }
}

